/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.query.Query;
import electric.xml.Element;

public class JqlClauseXmlHandler
implements ClauseXmlHandler {
    private final JqlQueryParser jqlQueryParser;

    public JqlClauseXmlHandler(JqlQueryParser jqlQueryParser) {
        this.jqlQueryParser = jqlQueryParser;
    }

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String xmlFieldId = el.getName();
        if (!"query".equals(xmlFieldId)) {
            return new ClauseXmlHandler.FailedConversionResult(xmlFieldId);
        }
        String jql = el.getTextString();
        try {
            if (jql == null) {
                jql = "";
            }
            Query query = this.jqlQueryParser.parseQuery(jql);
            return new ClauseXmlHandler.FullConversionResult(query.getWhereClause());
        }
        catch (JqlParseException e) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }
}

