/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.upgrade.tasks.jql.OrderByXmlHandler;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultOrderByXmlHandler
implements OrderByXmlHandler {
    private static final String OLD_SORT_CLASS = "com.atlassian.jira.issue.search.SearchSort";
    private static final Logger log = Logger.getLogger(DefaultOrderByXmlHandler.class);
    private final SearchHandlerManager searchHandlerManager;

    public DefaultOrderByXmlHandler(SearchHandlerManager searchHandlerManager) {
        this.searchHandlerManager = Assertions.notNull("searchHandlerManager", searchHandlerManager);
    }

    @Override
    public OrderByXmlHandler.OrderByConversionResults getOrderByFromXml(Elements elements) {
        ArrayList<OrderByXmlHandler.ConversionError> conversionErrors = new ArrayList<OrderByXmlHandler.ConversionError>();
        ArrayList<SearchSort> searchSorts = new ArrayList<SearchSort>();
        HashSet<String> sortFieldNames = new HashSet<String>();
        while (elements.hasMoreElements()) {
            SearchSort sort;
            String order;
            Element sortEl;
            Element element = (Element)elements.nextElement();
            String sortClass = element.getAttributeValue("class");
            if (!OLD_SORT_CLASS.equals(sortClass)) {
                log.warn((Object)("Unexpected sorting class '" + sortClass + "' encountered while converting search sorts."));
            }
            if ((sortEl = element.getElement("searchSort")) == null) {
                log.warn((Object)("Ignoring invalid sort detected during upgrade. Sort was '" + element + "'."));
                conversionErrors.add(new OrderByXmlHandler.ConversionError("jira.jql.upgrade.order.by.error.general", null));
                continue;
            }
            String field = sortEl.getAttribute("field");
            if (StringUtils.isBlank((String)field)) {
                log.warn((Object)("Ignoring invalid sort detected during upgrade. Sort was '" + element + "'."));
                conversionErrors.add(new OrderByXmlHandler.ConversionError("jira.jql.upgrade.order.by.error.general", null));
                continue;
            }
            if (sortFieldNames.contains(field)) {
                log.warn((Object)("Skipping sort since field name '" + field + "' has already been included in the sorts."));
                continue;
            }
            sortFieldNames.add(field);
            Collection<ClauseNames> names = this.searchHandlerManager.getJqlClauseNames(field);
            if (names.isEmpty()) {
                Long cfId = this.getId(field);
                if (cfId == null) {
                    log.warn((Object)("Ignoring invalid sort, unable to find JQL clause name for field '" + field + "'."));
                    conversionErrors.add(new OrderByXmlHandler.ConversionError("jira.jql.upgrade.order.by.error.can.not.convert", field));
                    continue;
                }
                log.warn((Object)("Creating a sort for a custom field with id '" + field + "' which is not found in the system."));
                order = sortEl.getAttribute("order");
                sort = new SearchSort(order, JqlCustomFieldId.toString(cfId));
                searchSorts.add(sort);
                continue;
            }
            ClauseNames name = names.iterator().next();
            order = sortEl.getAttribute("order");
            sort = new SearchSort(order, name.getPrimaryName());
            searchSorts.add(sort);
        }
        Collections.reverse(searchSorts);
        return new OrderByXmlHandler.OrderByConversionResults(new OrderByImpl(searchSorts), conversionErrors);
    }

    private Long getId(String elementName) {
        try {
            return Long.parseLong(elementName.substring("customfield_".length()));
        }
        catch (Exception e) {
            return null;
        }
    }
}

