/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.operator.Operator;
import electric.xml.Element;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

abstract class AbstractDateXmlHandler
implements ClauseXmlHandler {
    private static final Logger log = Logger.getLogger(AbstractDateXmlHandler.class);
    private final Collection<String> supportedXmlFieldNames;

    protected AbstractDateXmlHandler(Collection<String> supportedXmlFieldNames) {
        this.supportedXmlFieldNames = Assertions.notNull("supportedXmlFieldNames", supportedXmlFieldNames);
    }

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        Clause toClause;
        Assertions.notNull("el", el);
        String xmlFieldId = el.getName();
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a date clause for field with id '" + xmlFieldId + "' and no corresponding clause name could be found."));
            return new ClauseXmlHandler.FailedConversionResult(xmlFieldId);
        }
        Clause fromClause = this.createClause(clauseName, this.getLowerBound(clauseName, el), Operator.GREATER_THAN_EQUALS);
        Clause resultClause = this.getResultClause(fromClause, toClause = this.createClause(clauseName, this.getUpperBound(clauseName, el), Operator.LESS_THAN_EQUALS));
        if (resultClause == null) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        if (this.xmlFieldIdSupported(xmlFieldId)) {
            return new ClauseXmlHandler.FullConversionResult(resultClause);
        }
        return new ClauseXmlHandler.BestGuessConversionResult(resultClause, xmlFieldId, clauseName);
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }

    private Clause getResultClause(Clause fromClause, Clause toClause) {
        Clause resultClause = fromClause == null ? toClause : (toClause != null ? new AndClause(fromClause, toClause) : fromClause);
        return resultClause;
    }

    private Clause createClause(String fieldName, String date, Operator operator) {
        if (StringUtils.isNotBlank((String)date)) {
            return JqlQueryBuilder.newBuilder().where().addStringCondition(fieldName, operator, date).buildClause();
        }
        return null;
    }

    protected boolean xmlFieldIdSupported(String xmlFieldId) {
        return this.supportedXmlFieldNames.isEmpty() || this.supportedXmlFieldNames.contains(xmlFieldId);
    }

    protected abstract String getLowerBound(String var1, Element var2);

    protected abstract String getUpperBound(String var1, Element var2);
}

