/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpgradeTask_Build701
extends AbstractUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build701.class);
    private final XPathFactory xpathFactory = XPathFactory.newInstance();
    private final XPath xpath = this.xpathFactory.newXPath();
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public UpgradeTask_Build701() {
        super(false);
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    @Override
    public String getBuildNumber() {
        return "701";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        DescriptorFactory descriptorFactory = DescriptorFactory.getFactory();
        WorkflowManager workflowManager = ComponentAccessor.getComponentOfType(WorkflowManager.class);
        for (JiraWorkflow workflow : workflowManager.getWorkflows()) {
            if (!(workflow instanceof ConfigurableJiraWorkflow)) continue;
            ConfigurableJiraWorkflow mutableWorkflow = (ConfigurableJiraWorkflow)workflow;
            WorkflowDescriptor workflowDescriptor = descriptorFactory.createWorkflowDescriptor(this.upgradeDescriptor(mutableWorkflow.getDescriptor().asXML()));
            mutableWorkflow.setDescriptor(workflowDescriptor);
            workflowManager.saveWorkflowWithoutAudit(mutableWorkflow);
            log.debug("Upgraded workflow '{}'", (Object)mutableWorkflow.getName());
        }
    }

    private Element upgradeDescriptor(String descriptor) throws SQLException {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            Document workflow = documentBuilder.parse(new ByteArrayInputStream(descriptor.getBytes()));
            XPathExpression findConditionClass = this.xpath.compile("//arg[@name='class.name'][text()='com.opensymphony.workflow.util.OSUserGroupCondition']");
            NodeList conditionClasses = (NodeList)findConditionClass.evaluate(workflow, XPathConstants.NODESET);
            for (int i = 0; i < conditionClasses.getLength(); ++i) {
                Node arg = conditionClasses.item(i);
                arg.setTextContent("com.atlassian.jira.workflow.condition.UserInGroupCondition");
            }
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-public", "-//OpenSymphony Group//DTD OSWorkflow 2.8//EN");
            transformer.setOutputProperty("doctype-system", "http://www.opensymphony.com/osworkflow/workflow_2_8.dtd");
            DOMSource source = new DOMSource(workflow);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            return workflow.getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

