/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.user.DefaultUserPropertyManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build608
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build608.class);
    private AvatarManager avatarManager;
    private ApplicationProperties applicationProperties;
    private final OfBizDelegator ofBizDelegator;
    private final UserPropertyManager userPropertyManager;

    public UpgradeTask_Build608(AvatarManager avatarManager, ApplicationProperties applicationProperties, OfBizDelegator ofBizDelegator, UserPropertyManager userPropertyManager) {
        super(false);
        this.avatarManager = avatarManager;
        this.applicationProperties = applicationProperties;
        this.ofBizDelegator = ofBizDelegator;
        this.userPropertyManager = userPropertyManager;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        ArrayList<Long> systemAvatarIds = new ArrayList<Long>();
        for (Avatar avatar : this.avatarManager.getAllSystemAvatars(Avatar.Type.USER)) {
            systemAvatarIds.add(avatar.getId());
        }
        for (int i = 1; i <= 22; ++i) {
            this.createAvatar("Avatar-" + i + ".png");
        }
        Avatar defaultAvatar = this.createAvatar("Avatar-default.png");
        this.applicationProperties.setString("jira.avatar.user.default.id", defaultAvatar.getId().toString());
        Avatar anonymousAvatar = this.createAvatar("Avatar-unknown.png");
        this.applicationProperties.setString("jira.avatar.user.anonymous.id", anonymousAvatar.getId().toString());
        EntityConditionList entityCondition = new EntityConditionList(Arrays.asList(new EntityExpr("propertyKey", EntityOperator.EQUALS, (Object)"user.avatar.id"), new EntityExpr("propertyValue", EntityOperator.IN, systemAvatarIds)), EntityOperator.AND);
        List<GenericValue> propertiesToUpdate = this.ofBizDelegator.findByCondition("OSUserPropertySetNumberView", (EntityCondition)entityCondition, CollectionBuilder.list("id"));
        ArrayList<Long> primaryKeys = new ArrayList<Long>();
        for (GenericValue genericValue : propertiesToUpdate) {
            primaryKeys.add(genericValue.getLong("id"));
        }
        this.ofBizDelegator.bulkUpdateByPrimaryKey("OSPropertyNumber", MapBuilder.singletonMap("value", defaultAvatar.getId()), primaryKeys);
        for (Long systemAvatarId : systemAvatarIds) {
            this.avatarManager.delete(systemAvatarId);
        }
        if (this.userPropertyManager instanceof DefaultUserPropertyManager) {
            ((DefaultUserPropertyManager)this.userPropertyManager).onClearCache(null);
        } else {
            log.error((Object)("Expected to find a DefaultUserPropertyManager, but got " + this.userPropertyManager.getClass().getName()));
        }
    }

    private Avatar createAvatar(String fileName) {
        log.info((Object)("Creating system user avatar " + fileName));
        return this.avatarManager.create(AvatarImpl.createSystemAvatar(fileName, "image/png", Avatar.Type.USER));
    }

    @Override
    public String getShortDescription() {
        return "Updating system user avatars.";
    }

    @Override
    public String getBuildNumber() {
        return "608";
    }
}

