/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpgradeTask_Build604MailItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build604MailItem.class);
    private static final String EMAIL_TEMPLATE_PARTIAL = "partialsavedfilterconversion.vm";
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String EMAIL_TEMPLATES = "templates/email/text/";
    private static final String MIME_TYPE = "text/plain";
    private final Map velocityParams;
    private final UpgradeTask_Build604.UserSavedFilterConversionInformations userSavedFilterConversionInformations;

    public UpgradeTask_Build604MailItem(UpgradeTask_Build604.UserSavedFilterConversionInformations userSavedFilterConversionInformations) {
        this.userSavedFilterConversionInformations = userSavedFilterConversionInformations;
        this.velocityParams = new HashMap();
    }

    public void send() throws MailException {
        if (!JiraMailUtils.isHasMailServer()) {
            return;
        }
        try {
            User owner = UserUtils.getUser(this.userSavedFilterConversionInformations.getOwnerName());
            if (owner == null) {
                log.error((Object)("Error sending upgrade task 428 mail item, owner '" + this.userSavedFilterConversionInformations.getOwnerName() + "' not found"));
                return;
            }
            I18nBean i18nBean = this.getI18nBean(owner);
            this.velocityParams.put("owner", owner);
            this.velocityParams.put("i18n", i18nBean);
            this.velocityParams.put("helpUtil", HelpUtil.getInstance());
            this.velocityParams.put("conversionInformation", this.userSavedFilterConversionInformations);
            VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(ComponentAccessor.getApplicationProperties()).getJiraVelocityRequestContext();
            this.velocityParams.put("baseurl", velocityRequestContext.getBaseUrl());
            String body = ComponentAccessor.getVelocityManager().getEncodedBody(EMAIL_TEMPLATES, EMAIL_TEMPLATE_PARTIAL, ENCODING_UTF8, this.velocityParams);
            Email email = new Email(owner.getEmailAddress());
            email.setSubject(i18nBean.getText("template.filters.jql.partial.subject"));
            email.setBody(body);
            email.setMimeType(MIME_TYPE);
            email.setEncoding(ENCODING_UTF8);
            ManagerFactory.getMailQueue().addItem((MailQueueItem)new SingleMailQueueItem((com.atlassian.mail.Email)email));
        }
        catch (Exception e) {
            log.error((Object)"Error sending upgrade task 428 mail item", (Throwable)e);
        }
    }

    private I18nBean getI18nBean(User subscriber) {
        return new I18nBean(subscriber);
    }
}

