/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604MailItem;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandlerRegistry;
import com.atlassian.jira.upgrade.tasks.jql.JqlClauseXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.OrderByXmlHandler;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.order.OrderBy;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build604
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build604.class);
    private final ClauseXmlHandlerRegistry clauseXmlHandlerRegistry;
    private final OfBizDelegator ofBizDelegator;
    private final SearchService searchService;
    private final OrderByXmlHandler orderByXmlHandler;
    private final JqlQueryParser jqlQueryParser;
    private final MailQueue mailQueue;
    private final SearchHandlerManager searchHandlerManager;
    private final UserUtil userUtil;
    final Map<String, UserSavedFilterConversionInformations> userSavedFilterConversionInformationsMap;
    private final I18nHelper.BeanFactory i18n;

    public UpgradeTask_Build604(ClauseXmlHandlerRegistry clauseXmlHandlerRegistry, OfBizDelegator ofBizDelegator, SearchService searchService, OrderByXmlHandler orderByXmlHandler, JqlQueryParser jqlQueryParser, MailQueue mailQueue, SearchHandlerManager searchHandlerManager, UserUtil userUtil, I18nHelper.BeanFactory i18n) {
        super(false);
        this.clauseXmlHandlerRegistry = clauseXmlHandlerRegistry;
        this.ofBizDelegator = ofBizDelegator;
        this.searchService = searchService;
        this.orderByXmlHandler = orderByXmlHandler;
        this.jqlQueryParser = jqlQueryParser;
        this.mailQueue = mailQueue;
        this.i18n = i18n;
        this.searchHandlerManager = Assertions.notNull("searchHandlerManager", searchHandlerManager);
        this.userUtil = Assertions.notNull("userUtil", userUtil);
        this.userSavedFilterConversionInformationsMap = new HashMap<String, UserSavedFilterConversionInformations>();
    }

    @Override
    public String getBuildNumber() {
        return "604";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<Long> searchRequestIds = this.getSearchRequestIds();
        Context percentageLogger = this.getPercentageLogger(searchRequestIds);
        ArrayList<Long> batchSearchRequestIds = new ArrayList<Long>();
        for (Long searchRequestId : searchRequestIds) {
            batchSearchRequestIds.add(searchRequestId);
            if (batchSearchRequestIds.size() < 200) continue;
            this.upgradeSearchRequests(this.getSearchRequestGvsForIds(batchSearchRequestIds), percentageLogger);
            batchSearchRequestIds.clear();
        }
        if (!batchSearchRequestIds.isEmpty()) {
            this.upgradeSearchRequests(this.getSearchRequestGvsForIds(batchSearchRequestIds), percentageLogger);
        }
        this.sendEmailNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeSearchRequests(List<GenericValue> searchRequestGvs, Context percentageLogger) throws GenericEntityException {
        for (GenericValue searchRequestGv : searchRequestGvs) {
            String searchRequestName = searchRequestGv.getString("name");
            Long searchRequestId = searchRequestGv.getLong("id");
            Context.Task task = percentageLogger.start(searchRequestName + "(" + searchRequestId + ")");
            try {
                if (!this.requestRequiresUpgrade(searchRequestGv.getString("request"))) continue;
                Query query = this.getQueryFromXml(searchRequestGv);
                if (query != null) {
                    String jqlString = this.searchService.getGeneratedJqlString(query);
                    searchRequestGv.setString("request", jqlString);
                    searchRequestGv.store();
                    log.debug((Object)("Successfully converted filter '" + searchRequestName + "(" + searchRequestId + ")" + "' to JQL '" + jqlString + "'."));
                    continue;
                }
                Query falseQuery = JqlQueryBuilder.newBuilder().where().project().isEmpty().buildQuery();
                searchRequestGv.setString("request", this.searchService.getGeneratedJqlString(falseQuery));
                searchRequestGv.store();
                this.logConversionError(searchRequestGv);
            }
            finally {
                task.complete();
            }
        }
    }

    Query getNamifiedQuery(String ownerUserName, Query queryFromXml, Set<Clause> clausesNotToNamify) {
        try {
            if (queryFromXml.getWhereClause() == null) {
                return queryFromXml;
            }
            User queryOwner = this.userUtil.getUserObject(ownerUserName);
            if (queryOwner == null) {
                return queryFromXml;
            }
            SearchContext searchContext = this.searchService.getSearchContext(queryOwner, queryFromXml);
            NamifyingClauseVisitor visitor = new NamifyingClauseVisitor(queryOwner, this.searchHandlerManager, searchContext, clausesNotToNamify);
            Clause namifiedClause = queryFromXml.getWhereClause().accept(visitor);
            return new QueryImpl(namifiedClause, queryFromXml.getOrderByClause(), null);
        }
        catch (Exception e) {
            log.warn((Object)("Could not namify the query: '" + queryFromXml.getQueryString() + "'"), (Throwable)e);
            return queryFromXml;
        }
    }

    Context getPercentageLogger(final List<Long> searchRequestIds) {
        Context percentageLogger = Contexts.percentageLogger(new Sized(){

            @Override
            public int size() {
                return searchRequestIds.size();
            }

            @Override
            public boolean isEmpty() {
                return searchRequestIds.size() == 0;
            }
        }, log, "Converting search requests to JQL is {0}% complete.");
        percentageLogger.setName("Converting search requests to JQL.");
        return percentageLogger;
    }

    boolean requestRequiresUpgrade(String string) {
        try {
            if (string == null) {
                string = "";
            }
            this.jqlQueryParser.parseQuery(string);
            return false;
        }
        catch (JqlParseException e) {
            return true;
        }
    }

    List<GenericValue> getSearchRequestGvsForIds(List<Long> batchSearchRequestIds) {
        EntityExpr idCondition = new EntityExpr("id", EntityOperator.IN, batchSearchRequestIds);
        return this.ofBizDelegator.findByCondition("SearchRequest", (EntityCondition)idCondition, null);
    }

    List<Long> getSearchRequestIds() {
        ArrayList<Long> searchRequestIds = new ArrayList<Long>();
        List<GenericValue> searchRequestIdGvs = this.ofBizDelegator.findByCondition("SearchRequest", null, CollectionBuilder.list("id"));
        for (GenericValue searchRequestIdGv : searchRequestIdGvs) {
            searchRequestIds.add(searchRequestIdGv.getLong("id"));
        }
        return searchRequestIds;
    }

    Query getQueryFromXml(GenericValue searchRequestGv) {
        try {
            String requestString = searchRequestGv.getString("request");
            String ownerUserName = searchRequestGv.getString("author");
            Document doc = new Document(requestString);
            Elements paramEls = doc.getRoot().getElements("parameter");
            WhereClauseConversionResults whereClauseConversionResults = this.getWhereClauses(paramEls);
            OrderByXmlHandler.OrderByConversionResults orderByConversionResults = this.getOrderBy(doc.getRoot().getElements("sort"));
            List<Clause> convertedClauses = whereClauseConversionResults.getConvertedClauses();
            OrderBy convertedOrderBy = orderByConversionResults.getConvertedOrderBy();
            this.logConversionWarningIfNeeded(searchRequestGv, whereClauseConversionResults, orderByConversionResults);
            if (!convertedClauses.isEmpty()) {
                QueryImpl query;
                if (convertedClauses.size() == 1) {
                    query = new QueryImpl(convertedClauses.get(0), convertedOrderBy, null);
                } else {
                    AndClause andClause = new AndClause(convertedClauses);
                    query = new QueryImpl(andClause, convertedOrderBy, null);
                }
                return this.getNamifiedQuery(ownerUserName, query, whereClauseConversionResults.getClausesNotToNamify());
            }
            return new QueryImpl(null, convertedOrderBy, null);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    void sendEmailNotifications() {
        for (UserSavedFilterConversionInformations conversionInformations : this.userSavedFilterConversionInformationsMap.values()) {
            this.mailQueue.addItem((MailQueueItem)new UpgradeTask_Build604MailItem(conversionInformations));
        }
        this.userSavedFilterConversionInformationsMap.clear();
    }

    WhereClauseConversionResults getWhereClauses(Elements paramEls) {
        ArrayList<Clause> convertedClauses = new ArrayList<Clause>();
        LinkedHashSet<Clause> clausesNotToNamify = new LinkedHashSet<Clause>();
        ArrayList<ClauseXmlHandler.ConversionResult> conversionMessages = new ArrayList<ClauseXmlHandler.ConversionResult>();
        while (paramEls.hasMoreElements()) {
            ClauseXmlHandler handler;
            Element element = (Element)paramEls.nextElement();
            String paramClass = element.getAttributeValue("class");
            String jqlAttr = element.getAttributeValue("jql");
            Element searchParamElement = element.getElements().first();
            String searchParameterElementName = searchParamElement.getName();
            if ("true".equals(jqlAttr)) {
                log.info((Object)"Found an old-style search request with some embedded JQL, converting the JQL.");
                handler = this.createJqlClauseXmlHandler();
            } else {
                handler = this.clauseXmlHandlerRegistry.getClauseXmlHandler(paramClass, searchParameterElementName);
            }
            if (handler != null) {
                Clause convertedClause;
                ClauseXmlHandler.ConversionResult conversionResult = handler.convertXmlToClause(searchParamElement);
                ClauseXmlHandler.ConversionResultType resultType = conversionResult.getResultType();
                if (ClauseXmlHandler.ConversionResultType.FULL_CONVERSION != resultType && ClauseXmlHandler.ConversionResultType.NOOP_CONVERSION != resultType) {
                    conversionMessages.add(conversionResult);
                }
                if ((convertedClause = conversionResult.getClause()) == null) continue;
                convertedClauses.add(convertedClause);
                if (handler.isSafeToNamifyValue()) continue;
                clausesNotToNamify.add(convertedClause);
                continue;
            }
            log.error((Object)("Found a search parameter we don't have an XML handler for, " + paramClass + ". Element: " + element));
            conversionMessages.add(new ClauseXmlHandler.FailedConversionResult(searchParameterElementName));
        }
        return new WhereClauseConversionResults(convertedClauses, conversionMessages, clausesNotToNamify);
    }

    ClauseXmlHandler createJqlClauseXmlHandler() {
        return new JqlClauseXmlHandler(this.jqlQueryParser);
    }

    OrderByXmlHandler.OrderByConversionResults getOrderBy(Elements sortEls) {
        return this.orderByXmlHandler.getOrderByFromXml(sortEls);
    }

    void logConversionWarningIfNeeded(GenericValue searchRequestGv, WhereClauseConversionResults whereClauseConversionResults, OrderByXmlHandler.OrderByConversionResults orderByConversionResults) {
        if (!whereClauseConversionResults.getConversionMessages().isEmpty() || !orderByConversionResults.getConversionErrors().isEmpty()) {
            String searchRequestName = searchRequestGv.getString("name");
            Long searchRequestId = searchRequestGv.getLong("id");
            String ownerUserName = searchRequestGv.getString("author");
            String searchRequestIdString = searchRequestName + "(" + searchRequestId + ")";
            if (ownerUserName != null) {
                UserSavedFilterConversionInformations informations = this.userSavedFilterConversionInformationsMap.get(ownerUserName);
                if (informations == null) {
                    informations = new UserSavedFilterConversionInformations(ownerUserName);
                    this.userSavedFilterConversionInformationsMap.put(ownerUserName, informations);
                }
                informations.addConversionResult(new SavedFilterConversionInformation(ownerUserName, searchRequestName, searchRequestId, whereClauseConversionResults.getConversionMessages(), orderByConversionResults.getConversionErrors()));
            }
            I18nHelper i18nBean = this.getI18n();
            log.debug((Object)("---------------- Partial Conversion of filter '" + searchRequestIdString + " ----------"));
            for (ClauseXmlHandler.ConversionResult conversionResult : whereClauseConversionResults.getConversionMessages()) {
                log.debug((Object)conversionResult.getMessage(i18nBean, searchRequestName));
            }
            for (OrderByXmlHandler.ConversionError conversionError : orderByConversionResults.getConversionErrors()) {
                log.debug((Object)conversionError.getMessage(i18nBean, searchRequestName));
            }
            log.debug((Object)"--------------------------------------------------------");
        }
    }

    I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.US);
    }

    private void logConversionError(GenericValue searchRequestGv) {
        String searchRequestName = searchRequestGv.getString("name");
        Long searchRequestId = searchRequestGv.getLong("id");
        String ownerUserName = searchRequestGv.getString("author");
        if (ownerUserName != null) {
            UserSavedFilterConversionInformations informations = this.userSavedFilterConversionInformationsMap.get(ownerUserName);
            if (informations == null) {
                informations = new UserSavedFilterConversionInformations(ownerUserName);
                this.userSavedFilterConversionInformationsMap.put(ownerUserName, informations);
            }
            informations.addConversionResult(new SavedFilterConversionInformation(ownerUserName, searchRequestName, searchRequestId));
        }
        log.error((Object)("Error converting saved filter to JQL for search request with id '" + searchRequestId + "' and name '" + searchRequestName + "' owned by '" + ownerUserName + "' with XML '" + searchRequestGv.getString("request") + "'."));
    }

    public static class NamifyingClauseVisitor
    implements ClauseVisitor<Clause> {
        private final User user;
        private final SearchHandlerManager searchHandlerManager;
        private final SearchContext searchContext;
        private final Set<Clause> clausesNotToNamify;
        private boolean disableNamifyForTree = false;

        public NamifyingClauseVisitor(User user, SearchHandlerManager searchHandlerManager, SearchContext searchContext, Set<Clause> clausesNotToNamify) {
            this.user = Assertions.notNull("user", user);
            this.searchHandlerManager = Assertions.notNull("searchHandlerManager", searchHandlerManager);
            this.searchContext = Assertions.notNull("searchContext", searchContext);
            this.clausesNotToNamify = Assertions.notNull("clausesNotToNamify", clausesNotToNamify);
        }

        @Override
        public Clause visit(AndClause andClause) {
            boolean oldDisableNamifyForTree = this.disableNamifyForTree;
            if (this.clausesNotToNamify.contains(andClause)) {
                this.disableNamifyForTree = true;
            }
            ArrayList<Clause> subClauses = new ArrayList<Clause>();
            for (Clause clause : andClause.getClauses()) {
                subClauses.add(clause.accept(this));
            }
            this.disableNamifyForTree = oldDisableNamifyForTree;
            return new AndClause(subClauses);
        }

        @Override
        public Clause visit(NotClause notClause) {
            boolean oldDisableNamifyForTree = this.disableNamifyForTree;
            if (this.clausesNotToNamify.contains(notClause)) {
                this.disableNamifyForTree = true;
            }
            Clause newSubClause = notClause.getSubClause().accept(this);
            this.disableNamifyForTree = oldDisableNamifyForTree;
            return new NotClause(newSubClause);
        }

        @Override
        public Clause visit(OrClause orClause) {
            boolean oldDisableNamifyForTree = this.disableNamifyForTree;
            if (this.clausesNotToNamify.contains(orClause)) {
                this.disableNamifyForTree = true;
            }
            ArrayList<Clause> subClauses = new ArrayList<Clause>();
            for (Clause clause : orClause.getClauses()) {
                subClauses.add(clause.accept(this));
            }
            this.disableNamifyForTree = oldDisableNamifyForTree;
            return new OrClause(subClauses);
        }

        @Override
        public Clause visit(TerminalClause clause) {
            try {
                Clause namifiedClause;
                IssueSearcher<?> searcher = this.getSearcher(clause);
                if (searcher != null && (namifiedClause = this.namifyLeftAndRightHandSides(clause, searcher.getSearchInputTransformer())) != null) {
                    if (this.disableNamifyForTree || this.clausesNotToNamify.contains(clause)) {
                        namifiedClause = this.namifyLeftHandSide(clause, (TerminalClause)namifiedClause);
                    }
                    return namifiedClause;
                }
            }
            catch (Exception e) {
                log.warn((Object)("Could not namify the terminal clause '" + clause.toString() + "'"), (Throwable)e);
            }
            return clause;
        }

        @Override
        public Clause visit(WasClause clause) {
            return clause;
        }

        @Override
        public Clause visit(ChangedClause clause) {
            return clause;
        }

        private Clause namifyLeftAndRightHandSides(TerminalClause clause, SearchInputTransformer transformer) {
            FieldValuesHolderImpl valuesHolder = new FieldValuesHolderImpl();
            transformer.populateFromQuery(this.user, valuesHolder, new QueryImpl(clause), this.searchContext);
            return transformer.getSearchClause(this.user, valuesHolder);
        }

        private TerminalClause namifyLeftHandSide(TerminalClause clause, TerminalClause namifiedClause) {
            return new TerminalClauseImpl(namifiedClause.getName(), namifiedClause.getOperator(), clause.getOperand());
        }

        private IssueSearcher<?> getSearcher(TerminalClause clause) {
            Collection<IssueSearcher<?>> searchersByClauseName = this.searchHandlerManager.getSearchersByClauseName(this.user, clause.getName(), this.searchContext);
            if (searchersByClauseName.size() == 1) {
                return searchersByClauseName.iterator().next();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unable to resolve only one searcher for field '%s', found '%d' searchers", clause.getName(), searchersByClauseName.size()));
            }
            return null;
        }
    }

    public static class DocumentConstantToClauseNameResolver {
        private static final Map<String, String> constToClauseNameMap = new HashMap<String, String>();

        public static String getClauseName(String documentConstant) {
            String clauseName = constToClauseNameMap.get(documentConstant);
            if (clauseName != null) {
                return clauseName;
            }
            return DocumentConstantToClauseNameResolver.getClauseNameForCustomFieldDocumentConstant(documentConstant);
        }

        private static String getClauseNameForCustomFieldDocumentConstant(String documentConstantName) {
            if (documentConstantName != null && documentConstantName.startsWith("customfield_")) {
                try {
                    long cfId = Long.parseLong(documentConstantName.substring("customfield_".length()));
                    return JqlCustomFieldId.toString(cfId);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        static {
            constToClauseNameMap.put(SystemSearchConstants.forPriority().getIndexField(), SystemSearchConstants.forPriority().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forProject().getIndexField(), SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forIssueType().getIndexField(), SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forComponent().getIndexField(), SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forAffectedVersion().getIndexField(), SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forFixForVersion().getIndexField(), SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forResolution().getIndexField(), SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forStatus().getIndexField(), SystemSearchConstants.forStatus().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forSummary().getIndexField(), SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forDescription().getIndexField(), SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forEnvironment().getIndexField(), SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forComments().getUrlParameter(), SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forCreatedDate().getIndexField(), SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forUpdatedDate().getIndexField(), SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forDueDate().getIndexField(), SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forResolutionDate().getIndexField(), SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forReporter().getIndexField(), SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forAssignee().getIndexField(), SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forIssueId().getIndexField(), SystemSearchConstants.forIssueId().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put("key", SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forIssueParent().getIndexField(), SystemSearchConstants.forIssueParent().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forWorkRatio().getIndexField(), SystemSearchConstants.forWorkRatio().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forCurrentEstimate().getIndexField(), SystemSearchConstants.forCurrentEstimate().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forOriginalEstimate().getIndexField(), SystemSearchConstants.forOriginalEstimate().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forTimeSpent().getIndexField(), SystemSearchConstants.forTimeSpent().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forSecurityLevel().getIndexField(), SystemSearchConstants.forSecurityLevel().getJqlClauseNames().getPrimaryName());
            constToClauseNameMap.put(SystemSearchConstants.forVotes().getIndexField(), SystemSearchConstants.forVotes().getJqlClauseNames().getPrimaryName());
        }
    }

    static class WhereClauseConversionResults {
        private final List<Clause> convertedClauses;
        private final Set<Clause> clausesNotToNamify;
        private final List<ClauseXmlHandler.ConversionResult> conversionMessages;

        public WhereClauseConversionResults(List<Clause> convertedClauses, List<ClauseXmlHandler.ConversionResult> conversionMessages, Set<Clause> clausesNotToNamify) {
            this.convertedClauses = convertedClauses;
            this.conversionMessages = conversionMessages;
            this.clausesNotToNamify = clausesNotToNamify;
        }

        public List<Clause> getConvertedClauses() {
            return this.convertedClauses;
        }

        public List<ClauseXmlHandler.ConversionResult> getConversionMessages() {
            return this.conversionMessages;
        }

        public Set<Clause> getClausesNotToNamify() {
            return this.clausesNotToNamify;
        }
    }

    public static class SavedFilterConversionInformation {
        private final String ownerName;
        private final String filterName;
        private final Long filterId;
        private final Collection<ClauseXmlHandler.ConversionResult> whereConversionErrors;
        private final Collection<OrderByXmlHandler.ConversionError> orderByConversionErrors;

        SavedFilterConversionInformation(String ownerName, String filterName, Long filterId) {
            this.ownerName = ownerName;
            this.filterName = filterName;
            this.filterId = filterId;
            this.whereConversionErrors = null;
            this.orderByConversionErrors = null;
        }

        SavedFilterConversionInformation(String ownerName, String filterName, Long filterId, Collection<ClauseXmlHandler.ConversionResult> whereConversionErrors, Collection<OrderByXmlHandler.ConversionError> orderByConversionErrors) {
            this.ownerName = ownerName;
            this.filterName = filterName;
            this.filterId = filterId;
            this.whereConversionErrors = whereConversionErrors;
            this.orderByConversionErrors = orderByConversionErrors;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public Long getFilterId() {
            return this.filterId;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public Collection<ClauseXmlHandler.ConversionResult> getWhereConversionErrors() {
            return this.whereConversionErrors;
        }

        public Collection<OrderByXmlHandler.ConversionError> getOrderByConversionErrors() {
            return this.orderByConversionErrors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SavedFilterConversionInformation that = (SavedFilterConversionInformation)o;
            if (this.filterId != null ? !this.filterId.equals(that.filterId) : that.filterId != null) {
                return false;
            }
            if (this.filterName != null ? !this.filterName.equals(that.filterName) : that.filterName != null) {
                return false;
            }
            if (this.orderByConversionErrors != null ? !((Object)this.orderByConversionErrors).equals(that.orderByConversionErrors) : that.orderByConversionErrors != null) {
                return false;
            }
            if (this.ownerName != null ? !this.ownerName.equals(that.ownerName) : that.ownerName != null) {
                return false;
            }
            return this.whereConversionErrors != null ? ((Object)this.whereConversionErrors).equals(that.whereConversionErrors) : that.whereConversionErrors == null;
        }

        public int hashCode() {
            int result = this.ownerName != null ? this.ownerName.hashCode() : 0;
            result = 31 * result + (this.filterName != null ? this.filterName.hashCode() : 0);
            result = 31 * result + (this.filterId != null ? this.filterId.hashCode() : 0);
            result = 31 * result + (this.whereConversionErrors != null ? ((Object)this.whereConversionErrors).hashCode() : 0);
            result = 31 * result + (this.orderByConversionErrors != null ? ((Object)this.orderByConversionErrors).hashCode() : 0);
            return result;
        }
    }

    public static class UserSavedFilterConversionInformations {
        private final String ownerName;
        private final Collection<SavedFilterConversionInformation> usersSavedFilterConversionInformation;

        UserSavedFilterConversionInformations(String ownerName) {
            this.ownerName = Assertions.notNull("ownerName", ownerName);
            this.usersSavedFilterConversionInformation = new ArrayList<SavedFilterConversionInformation>();
        }

        public void addConversionResult(SavedFilterConversionInformation savedFilterConversionInformation) {
            this.usersSavedFilterConversionInformation.add(savedFilterConversionInformation);
        }

        public Collection<SavedFilterConversionInformation> getUsersSavedFilterConversionInformation() {
            return this.usersSavedFilterConversionInformation;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserSavedFilterConversionInformations that = (UserSavedFilterConversionInformations)o;
            if (this.ownerName != null ? !this.ownerName.equals(that.ownerName) : that.ownerName != null) {
                return false;
            }
            return this.usersSavedFilterConversionInformation != null ? ((Object)this.usersSavedFilterConversionInformation).equals(that.usersSavedFilterConversionInformation) : that.usersSavedFilterConversionInformation == null;
        }

        public int hashCode() {
            int result = this.ownerName != null ? this.ownerName.hashCode() : 0;
            result = 31 * result + (this.usersSavedFilterConversionInformation != null ? ((Object)this.usersSavedFilterConversionInformation).hashCode() : 0);
            return result;
        }
    }
}

