/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build571
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build571.class);
    private final OfBizDelegator ofBizDelegator;
    private final CustomFieldManager customFieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final MultiMap<String, Long, Set<Long>> customFieldIdToFieldLayoutItemId = MultiMaps.createSetMultiMap();
    private static final String FIELD_LAYOUT_ITEM = "FieldLayoutItem";
    private static final String FIELD_RENDERERTYPE = "renderertype";
    private static final String FIELD_FIELDIDENTIFIER = "fieldidentifier";
    private static final String MULTI_VERSION_CF_KEY = "com.atlassian.jira.plugin.system.customfieldtypes:multiversion";
    private static final String FIELD_ID = "id";

    public UpgradeTask_Build571(OfBizDelegator ofBizDelegator, CustomFieldManager customFieldManager, FieldLayoutManager fieldLayoutManager) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
        this.customFieldManager = customFieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<GenericValue> fieldLayoutItemGVs = this.ofBizDelegator.findByCondition(FIELD_LAYOUT_ITEM, null, CollectionBuilder.list(FIELD_FIELDIDENTIFIER, FIELD_ID));
        for (GenericValue fieldLayoutItemGV : fieldLayoutItemGVs) {
            String customFieldId = fieldLayoutItemGV.getString(FIELD_FIELDIDENTIFIER);
            if (!customFieldId.startsWith("customfield_")) continue;
            this.customFieldIdToFieldLayoutItemId.put(customFieldId, fieldLayoutItemGV.getLong(FIELD_ID));
        }
        ArrayList<Long> fieldLayoutItemIdsToUpdate = new ArrayList<Long>();
        for (Map.Entry entry : this.customFieldIdToFieldLayoutItemId.entrySet()) {
            String customFieldKey;
            CustomField customFieldObject = this.customFieldManager.getCustomFieldObject((String)entry.getKey());
            if (customFieldObject == null || !(customFieldKey = customFieldObject.getCustomFieldType().getKey()).equals(MULTI_VERSION_CF_KEY)) continue;
            fieldLayoutItemIdsToUpdate.addAll((Collection)entry.getValue());
        }
        try {
            log.info((Object)("Updating " + fieldLayoutItemIdsToUpdate.size() + " custom field field layout item(s) with autocomplete renderer default"));
            this.ofBizDelegator.bulkUpdateByPrimaryKey(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap(FIELD_RENDERERTYPE, HackyRendererType.FROTHER_CONTROL.getKey()), fieldLayoutItemIdsToUpdate);
            log.info((Object)"Updating system fields field layout item(s) with autocomplete renderer default");
            this.ofBizDelegator.bulkUpdateByAnd(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap(FIELD_RENDERERTYPE, HackyRendererType.FROTHER_CONTROL.getKey()), MapBuilder.build(FIELD_FIELDIDENTIFIER, "fixVersions"));
            this.ofBizDelegator.bulkUpdateByAnd(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap(FIELD_RENDERERTYPE, HackyRendererType.FROTHER_CONTROL.getKey()), MapBuilder.build(FIELD_FIELDIDENTIFIER, "versions"));
            this.ofBizDelegator.bulkUpdateByAnd(FIELD_LAYOUT_ITEM, MapBuilder.singletonMap(FIELD_RENDERERTYPE, HackyRendererType.FROTHER_CONTROL.getKey()), MapBuilder.build(FIELD_FIELDIDENTIFIER, "components"));
        }
        finally {
            this.fieldLayoutManager.refresh();
        }
    }

    @Override
    public String getShortDescription() {
        return "Initialize versions & components field renderers to autocomplete renderer default";
    }

    @Override
    public String getBuildNumber() {
        return "571";
    }
}

