/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import org.apache.log4j.Logger;

public class UpgradeTask_Build554
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build554.class);
    private AvatarManager avatarManager;
    private ApplicationProperties applicationProperties;

    public UpgradeTask_Build554(AvatarManager avatarManager, ApplicationProperties applicationProperties) {
        super(false);
        this.avatarManager = avatarManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        for (Avatar avatar : this.avatarManager.getAllSystemAvatars(Avatar.Type.USER)) {
            log.info((Object)"Deleting existing system avatar");
            this.avatarManager.delete(avatar.getId());
        }
        this.createAvatar("angel.png");
        this.createAvatar("businessman.png");
        this.createAvatar("businessman2.png");
        this.createAvatar("devil.png");
        this.createAvatar("doctor.png");
        this.createAvatar("dude1.png");
        this.createAvatar("dude2.png");
        this.createAvatar("dude3.png");
        this.createAvatar("dude4.png");
        this.createAvatar("dude5.png");
        this.createAvatar("ghost.png");
        this.createAvatar("security_agent.png");
        this.createAvatar("user1.png");
        this.createAvatar("user2.png");
        this.createAvatar("user3.png");
        this.createAvatar("user_headphones.png");
        Avatar a = this.createAvatar("userprofile_silhouette.png");
        this.applicationProperties.setString("jira.avatar.user.default.id", a.getId().toString());
    }

    private Avatar createAvatar(String fileName) {
        log.info((Object)("Creating system user avatar " + fileName));
        return this.avatarManager.create(AvatarImpl.createSystemAvatar(fileName, "image/png", Avatar.Type.USER));
    }

    @Override
    public String getShortDescription() {
        return "Creates system user avatars.";
    }

    @Override
    public String getBuildNumber() {
        return "554";
    }
}

