/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.util.LegacyPortletUpgradeTask;
import com.atlassian.jira.upgrade.util.LegacyPortletUpgradeTaskFactory;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build438
extends AbstractUpgradeTask {
    static final String COM_ATLASSIAN_JIRA_PLUGIN_SYSTEM_PORTLETS_TEXT = "com.atlassian.jira.plugin.system.portlets:text";
    static final String COM_ATLASSIAN_JIRA_GADGETS_TEXT_GADGET = "com.atlassian.jira.gadgets:text-gadget";
    private static final Logger log = Logger.getLogger(UpgradeTask_Build438.class);
    private final JiraPropertySetFactory propertySetFactory;
    private final LegacyPortletUpgradeTaskFactory legacyPortletUpgradeTaskFactory;
    private final OfBizDelegator ofBizDelegator;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;

    public UpgradeTask_Build438(OfBizDelegator ofBizDelegator, JiraPropertySetFactory propertySetFactory, LegacyPortletUpgradeTaskFactory legacyPortletUpgradeTaskFactory, PluginAccessor pluginAccessor, PluginController pluginController) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
        this.propertySetFactory = propertySetFactory;
        this.legacyPortletUpgradeTaskFactory = legacyPortletUpgradeTaskFactory;
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Map<String, LegacyPortletUpgradeTask> portletToUpgradeTasks = this.legacyPortletUpgradeTaskFactory.createPortletToUpgradeTaskMapping();
        LinkedHashMap<Long, String> portletIdToKey = new LinkedHashMap<Long, String>();
        OfBizListIterator iterator = null;
        try {
            iterator = this.ofBizDelegator.findListIteratorByCondition("PortletConfiguration", null);
            GenericValue portletConfigGV = iterator.next();
            while (portletConfigGV != null) {
                String portletKey = portletConfigGV.getString("portletId");
                if (StringUtils.isNotBlank((String)portletKey) && portletToUpgradeTasks.containsKey(portletKey)) {
                    portletIdToKey.put(portletConfigGV.getLong("id"), portletKey);
                }
                portletConfigGV = iterator.next();
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        Context updateContext = Contexts.percentageLogger(new MapSized(portletIdToKey), log, "Converting legacy portlets to gadgets is {0}% complete");
        for (Map.Entry entry : portletIdToKey.entrySet()) {
            Context.Task task = updateContext.start(entry);
            try {
                Long portletId = (Long)entry.getKey();
                String key = (String)entry.getValue();
                LegacyPortletUpgradeTask legacyPortletUpgradeTask = portletToUpgradeTasks.get(key);
                URI gadgetUri = legacyPortletUpgradeTask.getGadgetUri();
                this.ofBizDelegator.bulkUpdateByPrimaryKey("PortletConfiguration", MapBuilder.newBuilder().add("portletId", null).add("gadgetXml", gadgetUri.toASCIIString()).toMap(), CollectionBuilder.newBuilder(portletId).asList());
                PropertySet livePropertySet = this.propertySetFactory.buildNoncachingPropertySet("PortletConfiguration", portletId);
                Map<String, String> userPrefs = legacyPortletUpgradeTask.convertUserPrefs(livePropertySet);
                for (Map.Entry<String, String> userPref : userPrefs.entrySet()) {
                    this.ofBizDelegator.createValue("GadgetUserPreference", MapBuilder.newBuilder().add("portletconfiguration", portletId).add("userprefkey", (Long)((Object)userPref.getKey())).add("userprefvalue", (Long)((Object)userPref.getValue())).toMap());
                }
                this.removePropertySet(portletId);
            }
            finally {
                task.complete();
            }
        }
        this.copyPortletPluginStateForGadgets();
        this.flushPortletConfigurationCache();
    }

    void copyPortletPluginStateForGadgets() {
        if (this.pluginAccessor.isPluginModuleEnabled(COM_ATLASSIAN_JIRA_PLUGIN_SYSTEM_PORTLETS_TEXT)) {
            this.pluginController.enablePluginModule(COM_ATLASSIAN_JIRA_GADGETS_TEXT_GADGET);
        }
    }

    void flushPortletConfigurationCache() {
        PortletConfigurationStore component = ComponentManager.getComponent(PortletConfigurationStore.class);
        if (component != null && component instanceof FlushablePortletConfigurationStore) {
            FlushablePortletConfigurationStore store = (FlushablePortletConfigurationStore)component;
            store.flush();
        }
    }

    private void removePropertySet(Long portletId) {
        PropertySet livePropertySet = this.propertySetFactory.buildNoncachingPropertySet("PortletConfiguration", portletId);
        HashSet keys = new HashSet(livePropertySet.getKeys());
        for (String propertyKey : keys) {
            livePropertySet.remove(propertyKey);
        }
    }

    @Override
    public String getShortDescription() {
        return "Converts Legacy Portlets to Gadgets including user preferences.";
    }

    @Override
    public String getBuildNumber() {
        return "438";
    }

    static class MapSized
    implements Sized {
        private final Map map;

        public MapSized(Map map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }
    }
}

