/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.apache.log4j.Logger;

public class UpgradeTask_Build412
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build412.class);
    private AvatarManager avatarManager;
    private ProjectManager projectManager;
    private ApplicationProperties applicationProperties;

    public UpgradeTask_Build412(AvatarManager avatarManager, ProjectManager projectManager, ApplicationProperties applicationProperties) {
        super(false);
        this.avatarManager = avatarManager;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        for (Avatar avatar : this.avatarManager.getAllSystemAvatars(Avatar.Type.PROJECT)) {
            log.info((Object)"Deleting existing system avatar");
            this.avatarManager.delete(avatar.getId());
        }
        this.createAvatar("codegeist.png");
        this.createAvatar("eamesbird.png");
        this.createAvatar("jm_black.png");
        this.createAvatar("jm_brown.png");
        this.createAvatar("jm_orange.png");
        this.createAvatar("jm_red.png");
        this.createAvatar("jm_white.png");
        this.createAvatar("jm_yellow.png");
        this.createAvatar("monster.png");
        this.createAvatar("rainbow.png");
        this.createAvatar("kangaroo.png");
        Avatar a = this.createAvatar("rocket.png");
        List<Project> projects = this.projectManager.getProjectObjects();
        for (Project project : projects) {
            try {
                this.projectManager.updateProject(project, project.getName(), project.getDescription(), project.getLeadUserName(), project.getUrl(), project.getAssigneeType(), a.getId());
            }
            catch (Exception e) {
                log.error((Object)("Problem adding avatar to project " + project.getName()));
            }
        }
        this.applicationProperties.setString("jira.avatar.default.id", a.getId().toString());
    }

    private Avatar createAvatar(String fileName) {
        log.info((Object)("Creating system project avatar " + fileName));
        return this.avatarManager.create(AvatarImpl.createSystemAvatar(fileName, "image/png", Avatar.Type.PROJECT));
    }

    @Override
    public String getBuildNumber() {
        return "412";
    }
}

