/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraPermission;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.Collection;
import org.apache.log4j.Logger;

public class UpgradeTask_Build296
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build296.class);
    private final GlobalPermissionManager globalPermissionManager;

    public UpgradeTask_Build296(GlobalPermissionManager globalPermissionManager) {
        super(false);
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    public String getShortDescription() {
        return "Populates the JIRA System Administrator global permission with all groups associated with the JIRA Administrators global permission.";
    }

    @Override
    public String getBuildNumber() {
        return "296";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Collection<JiraPermission> groupsForSysAdmin = this.globalPermissionManager.getPermissions(44);
        if (groupsForSysAdmin != null && groupsForSysAdmin.isEmpty()) {
            Collection<JiraPermission> groupsForAdmin = this.globalPermissionManager.getPermissions(0);
            if (groupsForAdmin != null) {
                for (JiraPermission jiraPermission : groupsForAdmin) {
                    log.info((Object)("Creating a JIRA System Administrators permission entry for group '" + jiraPermission.getGroup() + "'."));
                    try {
                        this.globalPermissionManager.addPermission(44, jiraPermission.getGroup());
                    }
                    catch (CreateException e) {
                        log.error((Object)("Unable to create a JIRA System Administrators permission entry for group '" + jiraPermission.getGroup() + "'."));
                        throw e;
                    }
                }
            }
        } else {
            log.warn((Object)"The JIRA System Administrators Global Permission has group entries, this should not happen, this upgrade task will not run.");
        }
    }
}

