/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build175
extends AbstractUpgradeTask {
    public static final String BUILD_NUMBER = "175";
    private static final Logger LOG = Logger.getLogger(UpgradeTask_Build175.class);
    private ProjectRoleManager projectRoleManager = null;
    private final OfBizDelegator delegator;
    public static final String ROLE_USERS = "Users";
    public static final String ROLE_DEVELOPERS = "Developers";
    public static final String ROLE_ADMINISTRATORS = "Administrators";
    static final String ROLE_ACTOR_ROLETYPE = "roletype";
    static final String ROLE_ACTOR_PROJECTROLEID = "projectroleid";
    static final String ROLE_ACTOR_ENTITY_NAME = "ProjectRoleActor";
    static final String ROLE_ACTOR_PID = "pid";

    @Override
    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Adds the default project roles and populates their members.";
    }

    public UpgradeTask_Build175(ProjectRoleManager projectRoleManager, OfBizDelegator delegator) {
        super(false);
        this.projectRoleManager = projectRoleManager;
        this.delegator = delegator;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.createDefaultRoles();
    }

    private void createDefaultRoles() {
        ProjectRole projectRole;
        try {
            projectRole = this.projectRoleManager.createRole(new ProjectRoleImpl(ROLE_USERS, "A project role that represents users in a project"));
            if (this.groupExistsInOldTables("jira-users")) {
                this.createActorForDefaultRole(projectRole, "jira-users");
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Unable to create a project role named 'Users'", (Throwable)e);
        }
        try {
            projectRole = this.projectRoleManager.createRole(new ProjectRoleImpl(ROLE_DEVELOPERS, "A project role that represents developers in a project"));
            if (this.groupExistsInOldTables("jira-developers")) {
                this.createActorForDefaultRole(projectRole, "jira-developers");
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Unable to create a project role named 'Developers'", (Throwable)e);
        }
        try {
            projectRole = this.projectRoleManager.createRole(new ProjectRoleImpl(ROLE_ADMINISTRATORS, "A project role that represents administrators in a project"));
            if (this.groupExistsInOldTables("jira-administrators")) {
                this.createActorForDefaultRole(projectRole, "jira-administrators");
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Unable to create a project role named 'Administrators'", (Throwable)e);
        }
    }

    private void createActorForDefaultRole(ProjectRole projectRole, String actorName) {
        this.delegator.createValue(ROLE_ACTOR_ENTITY_NAME, EasyMap.build((Object)ROLE_ACTOR_PID, null, (Object)ROLE_ACTOR_PROJECTROLEID, (Object)projectRole.getId(), (Object)ROLE_ACTOR_ROLETYPE, (Object)"atlassian-group-role-actor", (Object)"roletypeparameter", (Object)actorName));
    }

    boolean groupExistsInOldTables(String groupName) {
        List<GenericValue> values = this.delegator.findByAnd("OSGroup", EasyMap.build((Object)"name", (Object)groupName));
        return values != null && !values.isEmpty();
    }
}

