/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UpgradeTask_Build150
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build150.class);
    public static final String systemEventTypeConfigFile = "upgrade-system-event-types.xml";
    public static final String ID_STRING = "id";
    public static final String NAME_STRING = "name";
    public static final String DESC_STRING = "description";
    public static final String TYPE_STRING = "type";
    public static final String NOTIFICATION_NAME = "notificationName";
    public static final String EVENT_NAME = "eventName";
    public static final String EVENT_COL_NAME = "event";
    public static final String EVENT_TYPE_ID = "eventTypeId";
    public static final String EVENT_TYPE = "eventType";
    public static final String NOTIFICATION_INSTANCE_ENTITY_NAME = "NotificationInstance";
    private Map nameIdMap = new HashMap();
    private final OfBizDelegator delegator;

    public UpgradeTask_Build150(OfBizDelegator delegator) {
        super(false);
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "150";
    }

    @Override
    public String getShortDescription() {
        return "Initialise the JIRA Event Type table with system event types and update the workflows and Notification and NotificationInstance tables with Event Type Ids.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.initSystemEventTypes();
        this.updateNotificationTable();
        this.updateWorkflows();
        this.updateNotificationInstanceTable();
    }

    private void initSystemEventTypes() throws Exception {
        InputStream is = null;
        try {
            is = ClassLoaderUtils.getResourceAsStream((String)systemEventTypeConfigFile, this.getClass());
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("eventtype");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                this.parseAction(action);
            }
        }
        catch (ParseException e) {
            log.error((Object)("Error parsing upgrade-system-event-types.xml: " + e.getMessage()), (Throwable)e);
            throw new ParseException("Error parsing upgrade-system-event-types.xml: " + e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not close event types inputStream.", (Throwable)e);
                throw new ParseException("Could not close event types inputStream: " + e.getMessage());
            }
        }
    }

    void parseAction(Element action) {
        String id = action.getAttributeValue(ID_STRING);
        Element nameKeyElement = action.getElement("i18n-name-key");
        Element descKeyElement = action.getElement("i18n-description-key");
        String name = action.getElement(NAME_STRING).getTextString();
        String desc = action.getElement(DESC_STRING).getTextString();
        String oldName = action.getElement(EVENT_NAME).getTextString();
        name = nameKeyElement == null ? name : this.getI18nTextWithDefault(nameKeyElement.getTextString(), name);
        desc = descKeyElement == null ? desc : this.getI18nTextWithDefault(descKeyElement.getTextString(), desc);
        this.nameIdMap.put(oldName, id);
        this.createNewEventIfNotExistAlready(id, name, desc);
    }

    private String getI18nTextWithDefault(String key, String defaultResult) {
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean();
    }

    private void createNewEventIfNotExistAlready(String id, String name, String desc) {
        boolean eventAlreadyExists;
        boolean bl = eventAlreadyExists = this.delegator.findByPrimaryKey("EventType", EasyMap.build((Object)ID_STRING, (Object)new Long(id))) != null;
        if (!eventAlreadyExists) {
            Map eventTypeParamasMap = EasyMap.build((Object)ID_STRING, (Object)new Long(id), (Object)NAME_STRING, (Object)name, (Object)DESC_STRING, (Object)desc, (Object)TYPE_STRING, (Object)"jira.system.event.type");
            this.delegator.createValue("EventType", eventTypeParamasMap);
        }
    }

    private void updateNotificationTable() throws Exception {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)systemEventTypeConfigFile, this.getClass());
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("eventtype");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                String originalEventName = action.getElement(NOTIFICATION_NAME).getTextString();
                Long id = new Long(action.getAttributeValue(ID_STRING));
                this.delegator.bulkUpdateByAnd("Notification", EasyMap.build((Object)EVENT_TYPE_ID, (Object)id), EasyMap.build((Object)EVENT_COL_NAME, (Object)originalEventName));
            }
        }
        catch (ParseException e) {
            log.error((Object)("Error parsing upgrade-system-event-types.xml: " + e.getMessage()), (Throwable)e);
            throw new ParseException("Error parsing upgrade-system-event-types.xml: " + e.getMessage());
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.error((Object)"Could not close event types inputStream.", (Throwable)e);
            throw new ParseException("Could not close event types inputStream: " + e.getMessage());
        }
    }

    private void updateWorkflows() throws Exception {
        ArrayList<String> changes = new ArrayList<String>();
        if (this.nameIdMap != null && !this.nameIdMap.isEmpty()) {
            WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();
            Collection<JiraWorkflow> workflows = workflowManager.getWorkflows();
            for (JiraWorkflow workflow : workflows) {
                if (workflow.getName().equals("jira")) continue;
                log.info((Object)("Inspecting workflow '" + workflow.getName() + "'."));
                Map<ActionDescriptor, Collection<FunctionDescriptor>> transitionPostFunctionMap = workflowManager.getPostFunctionsForWorkflow(workflow);
                Set<ActionDescriptor> keys = transitionPostFunctionMap.keySet();
                for (ActionDescriptor actionDescriptor : keys) {
                    Collection<FunctionDescriptor> postFunctions = transitionPostFunctionMap.get(actionDescriptor);
                    for (FunctionDescriptor functionDescriptor : postFunctions) {
                        String oldName;
                        if (!functionDescriptor.getArgs().containsKey(EVENT_TYPE) || (oldName = (String)functionDescriptor.getArgs().get(EVENT_TYPE)) == null) continue;
                        if (workflow.isSystemWorkflow()) {
                            changes.add(workflow.getName() + ": The <arg name=\"eventType\">" + oldName + "</arg> element needs to be replaced with <arg name=\"eventTypeId\">" + this.nameIdMap.get(oldName) + "</arg>.");
                            continue;
                        }
                        functionDescriptor.getArgs().remove(EVENT_TYPE);
                        functionDescriptor.getArgs().put(EVENT_TYPE_ID, this.nameIdMap.get(oldName));
                    }
                }
                if (workflow.isSystemWorkflow()) {
                    if (changes == null || changes.isEmpty()) continue;
                    log.warn((Object)("The workflow: " + workflow.getName() + " needs to be updated manually. Please refer to the following upgrade guide for further information: " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.confluence.update.event.workflows")));
                    log.warn((Object)"The following manual updates are required:");
                    for (String change : changes) {
                        log.warn((Object)change);
                    }
                    continue;
                }
                try {
                    workflowManager.saveWorkflowWithoutAudit(workflow);
                }
                catch (WorkflowException e) {
                    log.error((Object)("Unable to modify the workflow:" + workflow.getName() + ". If this workflow is saved externally to JIRA, it will need to be" + "manually updated as detailed at:" + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.confluence.update.event.workflows")));
                    throw new WorkflowException("Unable to modify the workflow:" + workflow.getName() + ".");
                }
            }
        } else {
            log.error((Object)"Unable to update workflows with event type ids");
            throw new Exception("Unable to update workflows with event type ids");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNotificationInstanceTable() throws Exception {
        InputStream is = null;
        try {
            is = ClassLoaderUtils.getResourceAsStream((String)systemEventTypeConfigFile, this.getClass());
            if (is != null) {
                Document doc = new Document(is);
                Element root = doc.getRoot();
                Elements actions = root.getElements("eventtype");
                long count = this.delegator.getCount(NOTIFICATION_INSTANCE_ENTITY_NAME);
                if (count > 0L) {
                    String message = "Updating " + count + " records in the '" + NOTIFICATION_INSTANCE_ENTITY_NAME + "' table.";
                    String message2 = "This might take a long time. Please do NOT stop JIRA.";
                    int repeatCount = Math.max(message.length(), message2.length());
                    log.info((Object)StringUtils.repeat((String)"*", (int)repeatCount));
                    log.info((Object)message);
                    log.info((Object)message2);
                    log.info((Object)StringUtils.repeat((String)"*", (int)repeatCount));
                    while (actions.hasMoreElements()) {
                        Element action = (Element)actions.nextElement();
                        String originalEventName = "NOTIFICATION_" + action.getElement(NOTIFICATION_NAME).getTextString();
                        Long id = new Long(action.getAttributeValue(ID_STRING));
                        log.info((Object)("Updating records of type '" + originalEventName + "'."));
                        this.delegator.bulkUpdateByAnd(NOTIFICATION_INSTANCE_ENTITY_NAME, EasyMap.build((Object)TYPE_STRING, (Object)("NOTIFICATION_" + id)), EasyMap.build((Object)TYPE_STRING, (Object)originalEventName));
                    }
                    log.info((Object)"Update of 'NotificationInstance' records finished.");
                } else {
                    log.info((Object)"No records in 'NotificationInstance' table to update.");
                }
            } else {
                log.error((Object)"Could not find file 'upgrade-system-event-types.xml'.");
                log.error((Object)"Records in NotificationInstance table will not be updated, and notification e-mails for existing issues will not be threaded.");
            }
        }
        catch (ParseException e) {
            log.error((Object)("Error parsing upgrade-system-event-types.xml: " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred : " + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not close event types inputStream.", (Throwable)e);
            }
        }
    }
}

