/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build130
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build130.class);
    private final OfBizDelegator delegator;

    public UpgradeTask_Build130(OfBizDelegator delegator) {
        super(false);
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "130";
    }

    @Override
    public String getShortDescription() {
        return "Grant the global 'Bulk Change' permission to all groups that have the global 'JIRA Users' permission.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        GlobalPermissionManager globalPermissionManager = ManagerFactory.getGlobalPermissionManager();
        for (String groupName : this.getGroupNamesWithUsePermission()) {
            globalPermissionManager.addPermission(33, groupName != null ? groupName : null);
        }
    }

    Collection<String> getGroupNamesWithUsePermission() {
        ArrayList<String> groupNames = new ArrayList<String>();
        List<GenericValue> globalPermissionsOfType = this.delegator.findByAnd("SchemePermissions", EasyMap.build((Object)"scheme", null, (Object)"permission", (Object)1, (Object)"type", (Object)"group"));
        for (GenericValue genericValue : globalPermissionsOfType) {
            groupNames.add(genericValue.getString("parameter"));
        }
        return groupNames;
    }
}

