/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UpgradeTask_Build102
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build102.class);
    private final ConstantsManager constantsManager;

    public UpgradeTask_Build102(ConstantsManager constantsManager) {
        super(false);
        this.constantsManager = constantsManager;
    }

    @Override
    public String getBuildNumber() {
        return "102";
    }

    @Override
    public String getShortDescription() {
        return "Sets a default resolution if there isn't already one";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Collection<Resolution> resolutionObjects;
        String defaultResolution = this.getApplicationProperties().getString("jira.constant.default.resolution");
        if (StringUtils.isBlank((String)defaultResolution) && (resolutionObjects = this.constantsManager.getResolutionObjects()) != null && !resolutionObjects.isEmpty()) {
            Resolution resolution = resolutionObjects.iterator().next();
            this.getApplicationProperties().setString("jira.constant.default.resolution", resolution.getId());
        }
    }
}

