/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build101
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build101.class);
    private final FieldConfigSchemeManager configSchemeManager;
    private final JiraContextTreeManager contextTreeManager;
    private final FieldManager fieldManager;
    private final ApplicationProperties applicationProperties;
    private final OfBizDelegator delegator;
    private final IssueTypeSchemeManager issueTypeSchemeManager;

    public UpgradeTask_Build101(FieldConfigSchemeManager configSchemeManager, JiraContextTreeManager contextTreeManager, FieldManager fieldManager, ApplicationProperties applicationProperties, OfBizDelegator delegator, IssueTypeSchemeManager issueTypeSchemeManager) {
        super(false);
        this.configSchemeManager = configSchemeManager;
        this.contextTreeManager = contextTreeManager;
        this.fieldManager = fieldManager;
        this.applicationProperties = applicationProperties;
        this.delegator = delegator;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    @Override
    public String getBuildNumber() {
        return "101";
    }

    @Override
    public String getShortDescription() {
        return "Create default issue type schemes for the current issue types";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<JiraContextNode> issueContextNodes = CustomFieldUtils.buildJiraIssueContexts(true, null, null, this.contextTreeManager);
        ConfigurableField issueTypeSystemField = this.fieldManager.getConfigurableField("issuetype");
        FieldConfigScheme fieldConfigScheme = this.configSchemeManager.createDefaultScheme(issueTypeSystemField, issueContextNodes);
        this.applicationProperties.setString("jira.scheme.default.issue.type", fieldConfigScheme.getId().toString());
        FieldConfigScheme defaultScheme = this.issueTypeSchemeManager.getDefaultIssueTypeScheme();
        FieldConfig defaultConfig = defaultScheme.getOneAndOnlyConfig();
        FieldConfigScheme.Builder builder = new FieldConfigScheme.Builder(defaultScheme);
        builder.setName("Default Issue Type Scheme");
        builder.setDescription("Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.");
        FieldConfigScheme defaultIssueTypeScheme = builder.toFieldConfigScheme();
        this.configSchemeManager.updateFieldConfigScheme(defaultIssueTypeScheme);
        log.info((Object)("Default scheme created '" + defaultIssueTypeScheme.getName() + "' (id: " + defaultIssueTypeScheme.getId() + ") and config id " + defaultConfig.getId()));
        List<GenericValue> allIssueTypesGv = this.delegator.findAll("IssueType", EasyList.build((Object)"style ASC", (Object)"sequence ASC"));
        int i = 0;
        String firstIssueTypeId = null;
        for (GenericValue issueType : allIssueTypesGv) {
            if (i == 0) {
                firstIssueTypeId = issueType.getString("id");
            }
            this.delegator.createValue("OptionConfiguration", EasyMap.build((Object)"fieldconfig", (Object)defaultConfig.getId(), (Object)"fieldid", (Object)defaultConfig.getFieldId(), (Object)"optionid", (Object)issueType.getString("id"), (Object)"sequence", (Object)new Long(i)));
            ++i;
        }
        String defaultIssueType = this.getApplicationProperties().getString("jira.constant.default.issue.type");
        if (StringUtils.isNotBlank((String)defaultIssueType)) {
            this.issueTypeSchemeManager.setDefaultValue(defaultConfig, defaultIssueType);
        } else {
            this.issueTypeSchemeManager.setDefaultValue(defaultConfig, firstIssueTypeId);
        }
    }
}

