/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.UnscreenableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractFieldScreenUpgradeTask
extends AbstractUpgradeTask {
    protected AbstractFieldScreenUpgradeTask(boolean reindexrequired) {
        super(reindexrequired);
    }

    protected void populateFieldScreenTab(FieldManager fieldManager, FieldLayout fieldLayout, FieldScreenTab fieldScreenTab) throws GenericEntityException {
        List layoutItemGVs = this.getDelegator().findByAnd("FieldLayoutItem", EasyMap.build((Object)"fieldlayout", (Object)fieldLayout.getId()), EasyList.build((Object)"verticalposition ASC"));
        LinkedList<FieldLayoutItem> fieldLayoutItems = new LinkedList<FieldLayoutItem>(fieldLayout.getFieldLayoutItems());
        for (GenericValue fieldLayoutItemGV : layoutItemGVs) {
            String fieldId = fieldLayoutItemGV.getString("fieldidentifier");
            OrderableField orderableField = fieldManager.getOrderableField(fieldId);
            if ("resolution".equals(fieldId) || orderableField == null || orderableField instanceof UnscreenableField || fieldLayout.getFieldLayoutItem(orderableField) == null) continue;
            fieldScreenTab.addFieldScreenLayoutItem(fieldId);
            this.removeItemFromList(fieldLayoutItems, fieldId);
        }
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            if (fieldLayoutItem == null || fieldLayoutItem.getOrderableField() == null || fieldLayoutItem.isHidden() || "resolution".equals(fieldLayoutItem.getOrderableField().getId()) || fieldLayoutItem.getOrderableField() instanceof UnscreenableField) continue;
            fieldScreenTab.addFieldScreenLayoutItem(fieldLayoutItem.getOrderableField().getId());
        }
        OrderableField timtetrackingField = fieldManager.getOrderableField("timetracking");
        if (fieldLayout.getFieldLayoutItem(timtetrackingField) == null) {
            fieldScreenTab.addFieldScreenLayoutItem(timtetrackingField.getId());
        }
    }

    private void removeItemFromList(List fieldLayoutItems, String fieldId) {
        Iterator iterator = fieldLayoutItems.iterator();
        while (iterator.hasNext()) {
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)iterator.next();
            if (!fieldId.equals(fieldLayoutItem.getOrderableField().getId())) continue;
            iterator.remove();
            break;
        }
    }
}

