/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.task.TaskProgressIndicator;
import com.atlassian.jira.task.TaskProgressListener;
import com.atlassian.jira.task.TaskProgressSink;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

class TaskProgressAdapter
implements TaskProgressIndicator,
TaskProgressSink {
    private volatile TaskDescriptor<?> taskDescriptor = null;
    private final AtomicReference<TaskProgressEvent> lastTaskProgressEvent = new AtomicReference<Object>(null);
    private final List<EventListener> listenerList = new CopyOnWriteArrayList<EventListener>();

    TaskProgressAdapter() {
    }

    @Override
    public void addListener(TaskProgressListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeListener(TaskProgressListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public TaskProgressEvent getLastProgressEvent() {
        return this.lastTaskProgressEvent.get();
    }

    @Override
    public void makeProgress(long taskProgress, String currentSubTask, String message) {
        long elapsedRunTime = this.taskDescriptor.getElapsedRunTime();
        TaskProgressEvent tpe = new TaskProgressEvent(this.taskDescriptor.getTaskId(), elapsedRunTime, taskProgress, currentSubTask, message);
        this.lastTaskProgressEvent.set(tpe);
        for (EventListener element : this.listenerList) {
            TaskProgressListener taskProgressListener = (TaskProgressListener)element;
            taskProgressListener.onProgressMade(tpe);
        }
    }

    void setTaskDescriptor(TaskDescriptor taskDescriptor) {
        this.taskDescriptor = taskDescriptor;
    }
}

