/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.task.TaskProgressSink;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class LoggingProgressSink
implements TaskProgressSink {
    private final Logger log;
    private final String message;
    private final int increment;
    private long lastProgress = 0L;

    public LoggingProgressSink(Logger logger, String message, int increment) {
        this.log = logger;
        this.message = message;
        this.increment = increment;
    }

    @Override
    public void makeProgress(long taskProgress, String currentSubTask, String msg) {
        if (taskProgress - this.lastProgress >= (long)this.increment) {
            this.log.info((Object)MessageFormat.format(this.message, taskProgress));
            this.lastProgress = taskProgress;
        }
    }
}

