/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.PluginInfo;
import com.atlassian.jira.startup.PluginInfoProvider;
import com.atlassian.jira.startup.PluginInfos;
import com.atlassian.jira.startup.PluginInfosImpl;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PluginInfoProviderImpl
implements PluginInfoProvider {
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;

    public PluginInfoProviderImpl(PluginAccessor pluginAccessor, PluginMetadataManager pluginMetadataManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
    }

    @Override
    public PluginInfos getSystemPlugins() {
        return this.getSystemPlugins(true);
    }

    @Override
    public PluginInfos getSystemPlugins(boolean includeBuiltInPlugins) {
        List<Plugin> systemPlugins = Collections2.filter((Collection)this.pluginAccessor.getPlugins(), (Predicate)new SystemPluginPredicate());
        if (!includeBuiltInPlugins) {
            systemPlugins = this.filterOutTrulyBuiltInPlugins((Collection<Plugin>)systemPlugins);
        }
        return this.toPluginInfo("System Plugins", systemPlugins);
    }

    @Override
    public PluginInfos getUserPlugins() {
        Collection plugins = this.pluginAccessor.getPlugins();
        Iterable userPlugins = Iterables.filter((Iterable)plugins, (Predicate)Predicates.not((Predicate)new SystemPluginPredicate()));
        return this.toPluginInfo("User Plugins", userPlugins);
    }

    protected List<Plugin> filterOutTrulyBuiltInPlugins(Collection<Plugin> pluginInfos) {
        String[] IGNORE_THOSE_STARTING_WITH = new String[]{"jira.webfragments", "com.atlassian.jira.plugin.wiki", "com.atlassian.jira.plugin.system", "jira.issueviews", "jira.footer", "jira.top.navigation.bar", "jira.webresources"};
        ArrayList filtered = Lists.newArrayListWithCapacity((int)pluginInfos.size());
        for (Plugin pluginInfo : pluginInfos) {
            String pluginKey = pluginInfo.getKey();
            boolean add = true;
            for (String partialKey : IGNORE_THOSE_STARTING_WITH) {
                if (!StringUtils.defaultString((String)pluginKey).startsWith(partialKey)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            filtered.add(pluginInfo);
        }
        return filtered;
    }

    private PluginInfos toPluginInfo(String name, Iterable<Plugin> plugins) {
        Iterable pluginInfoIterable = Iterables.transform(plugins, (Function)new Function<Plugin, PluginInfo>(){

            public PluginInfo apply(final Plugin plugin) {
                final PluginInformation pluginInformation = plugin.getPluginInformation();
                final PluginState state = plugin.getPluginState();
                final boolean isSystemPlugin = !PluginInfoProviderImpl.this.pluginMetadataManager.isUserInstalled(plugin);
                final boolean unloadablePlugin = plugin instanceof UnloadablePlugin;
                final String unloadbleReason = unloadablePlugin ? ((UnloadablePlugin)plugin).getErrorText() : "";
                return new PluginInfo(){

                    private String nvl(Object o) {
                        return o == null ? "" : String.valueOf(o);
                    }

                    @Override
                    public int getPluginsVersion() {
                        return plugin.getPluginsVersion();
                    }

                    @Override
                    public String getKey() {
                        return this.nvl(plugin.getKey());
                    }

                    @Override
                    public String getName() {
                        return this.nvl(plugin.getName());
                    }

                    @Override
                    public PluginInformation getPluginInformation() {
                        return pluginInformation;
                    }

                    @Override
                    public String getUnloadableReason() {
                        return this.nvl(unloadbleReason);
                    }

                    @Override
                    public boolean isUnloadable() {
                        return unloadablePlugin;
                    }

                    @Override
                    public boolean isEnabled() {
                        return state == PluginState.ENABLED;
                    }

                    @Override
                    public boolean isSystemPlugin() {
                        return isSystemPlugin;
                    }
                };
            }
        });
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>();
        Iterables.addAll(pluginInfos, (Iterable)pluginInfoIterable);
        Collections.sort(pluginInfos, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo p1, PluginInfo p2) {
                int rc = p1.getName().compareTo(p2.getName());
                if (rc == 0) {
                    rc = p1.getKey().compareTo(p2.getKey());
                }
                return rc;
            }
        });
        return new PluginInfosImpl(name, pluginInfos);
    }

    private class SystemPluginPredicate
    implements Predicate<Plugin> {
        private SystemPluginPredicate() {
        }

        public boolean apply(@Nullable Plugin input) {
            return !PluginInfoProviderImpl.this.pluginMetadataManager.isUserInstalled(input);
        }
    }
}

