/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class JiraStartupChecklistFilter
implements Filter {
    private static final Logger log = Logger.getLogger(JiraStartupChecklistFilter.class);
    private static final String SUFFIX = "JiraLockedError";
    private static final String LOCKED_TEMPLATE_NAME = "templates/jira/appconsistency/jiralocked.vm";
    private static final String NOERRORS_TEMPLATE_NAME = "templates/jira/appconsistency/no-errors-detected.vm";
    private VelocityEngine velocityEngine;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (JiraStartupChecklist.startupOK()) {
            if (httpServletRequest.getRequestURI().endsWith(SUFFIX)) {
                try {
                    String contextPath = StringUtils.isBlank((String)httpServletRequest.getContextPath()) ? "/" : httpServletRequest.getContextPath();
                    ImmutableMap parameters = ImmutableMap.of((Object)"contextPath", (Object)contextPath);
                    httpServletResponse.setContentType("text/html; charset=UTF-8");
                    this.getVelocityEngine().mergeTemplate(NOERRORS_TEMPLATE_NAME, "UTF-8", (Context)new VelocityContext((Map)parameters), (Writer)httpServletResponse.getWriter());
                }
                catch (Exception e) {
                    throw new ServletException("Exception occurred while rendering template 'templates/jira/appconsistency/no-errors-detected.vm'.", (Throwable)e);
                }
            } else {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (httpServletRequest.getRequestURI().endsWith(SUFFIX)) {
            ImmutableMap parameters = ImmutableMap.of((Object)"failedStartupCheck", (Object)JiraStartupChecklist.getFailedStartupCheck());
            try {
                httpServletResponse.setContentType("text/html; charset=UTF-8");
                this.getVelocityEngine().mergeTemplate(LOCKED_TEMPLATE_NAME, "UTF-8", (Context)new VelocityContext((Map)parameters), (Writer)httpServletResponse.getWriter());
            }
            catch (Exception e) {
                throw new ServletException("Exception occurred while rendering template 'templates/jira/appconsistency/jiralocked.vm'.", (Throwable)e);
            }
        } else {
            httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/" + SUFFIX);
        }
    }

    private synchronized VelocityEngine getVelocityEngine() {
        if (this.velocityEngine == null) {
            this.velocityEngine = new VelocityEngine();
            this.initialiseVelocityEngine(this.velocityEngine);
        }
        return this.velocityEngine;
    }

    private void initialiseVelocityEngine(VelocityEngine velocityEngine) {
        try {
            Properties props = new Properties();
            try {
                props.load(ClassLoaderUtils.getResourceAsStream((String)"velocity.properties", this.getClass()));
            }
            catch (Exception e) {
                props.put("resource.loader", "class");
                props.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
                props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            }
            velocityEngine.init(props);
        }
        catch (Exception e) {
            log.error((Object)("Exception initialising Velocity: " + e), (Throwable)e);
        }
    }
}

