/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.BootstrappingStartupState;
import com.atlassian.jira.startup.JiraStartupState;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.Tenant;
import java.util.concurrent.atomic.AtomicReference;

public class JiraStartupChecklist {
    private static MultiTenantComponentMap<JiraStartupChecklist> INSTANCE_MAP;
    private final AtomicReference<JiraStartupState> startupState = new AtomicReference();

    public JiraStartupChecklist() {
        this.startupState.set(new BootstrappingStartupState(this.startupState));
    }

    public static synchronized JiraStartupChecklist getInstance() {
        if (INSTANCE_MAP == null) {
            INSTANCE_MAP = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)new MultiTenantCreator<JiraStartupChecklist>(){

                public JiraStartupChecklist create(Tenant tenant) {
                    return new JiraStartupChecklist();
                }
            }).setNoTenantStrategy(MultiTenantComponentMap.NoTenantStrategy.SYSTEM).registerListener(MultiTenantComponentMap.Registration.NO).construct();
        }
        return (JiraStartupChecklist)INSTANCE_MAP.get();
    }

    public static void destroyTenant(Tenant tenant) {
        INSTANCE_MAP.onTenantStop(tenant);
    }

    public static boolean startupOK() {
        return JiraStartupChecklist.getInstance().startupState().isStartupChecksPassed();
    }

    public static StartupCheck getFailedStartupCheck() {
        return JiraStartupChecklist.getInstance().startupState().getFailedStartupCheck();
    }

    public static void setFailedStartupCheck(StartupCheck startupCheck) {
        JiraStartupChecklist.getInstance().startupState().setFailedStartupCheck(startupCheck);
    }

    public static void stop() {
        JiraStartupChecklist.getInstance().startupState().onJiraStopping();
    }

    protected JiraStartupState startupState() {
        return this.startupState.get();
    }
}

