/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.startup.JiraHomeException;
import com.atlassian.jira.startup.JiraHomeLockAcquirer;
import com.atlassian.jira.startup.JiraHomePathLocator;
import com.atlassian.jira.startup.MultiTenantJiraHomeLocator;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.SystemTenantJiraHomeLocator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.Tenant;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedSet;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JiraHomeStartupCheck
implements StartupCheck {
    private static final Logger log = Logger.getLogger(JiraHomeStartupCheck.class);
    private static final JiraHomeStartupCheck SYSTEM_TENANT_CHECK = new JiraHomeStartupCheck(new SystemTenantJiraHomeLocator());
    private static MultiTenantComponentMap<JiraHomeStartupCheck> INSTANCE_MAP;
    private final JiraHomePathLocator locator;
    private final JiraHomeLockAcquirer lockAcquirer;
    private volatile String faultDescription;
    private volatile String faultDescriptionHtml;
    private volatile File jiraHomeDirectory;
    private volatile boolean initalised = false;

    public static synchronized JiraHomeStartupCheck getInstance() {
        if (!MultiTenantContext.isEnabled()) {
            return SYSTEM_TENANT_CHECK;
        }
        if (INSTANCE_MAP == null) {
            INSTANCE_MAP = MultiTenantContext.getFactory().createComponentMapBuilder((MultiTenantCreator)new MultiTenantCreator<JiraHomeStartupCheck>(){

                public JiraHomeStartupCheck create(Tenant tenant) {
                    if (tenant == MultiTenantContext.getSystemTenant()) {
                        return SYSTEM_TENANT_CHECK;
                    }
                    return new JiraHomeStartupCheck(new MultiTenantJiraHomeLocator());
                }
            }).setNoTenantStrategy(MultiTenantComponentMap.NoTenantStrategy.SYSTEM).construct();
        }
        return (JiraHomeStartupCheck)INSTANCE_MAP.get();
    }

    public JiraHomeStartupCheck(JiraHomePathLocator locator) {
        this.locator = locator;
        this.lockAcquirer = new JiraHomeLockAcquirer();
    }

    @Override
    public String getName() {
        return "Jira.Home Startup Check";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOk() {
        if (!this.initalised) {
            try {
                String jiraHome = this.getConfiguredJiraHome();
                this.jiraHomeDirectory = this.validateJiraHome(jiraHome);
            }
            catch (JiraHomeException ex) {
                this.faultDescriptionHtml = ex.getHtmlMessage();
                this.faultDescription = ex.getMessage();
            }
            finally {
                this.initalised = true;
            }
        }
        return this.jiraHomeDirectory != null;
    }

    public boolean isInitialised() {
        return this.initalised;
    }

    private String getConfiguredJiraHome() throws JiraHomeException {
        String home = this.locator.getJiraHome();
        if (StringUtils.isBlank((String)home)) {
            HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath("jirahome");
            String s = "No jira.home is configured.\nSee %s for instructions on setting jira.home";
            String plainText = String.format("No jira.home is configured.\nSee %s for instructions on setting jira.home", helpPath.getUrl());
            String href = String.format("<a href=\"%s\">%s</a>", helpPath.getUrl(), TextUtils.htmlEncode((String)helpPath.getTitle()));
            String htmlText = String.format(TextUtils.htmlEncode((String)"No jira.home is configured.\nSee %s for instructions on setting jira.home"), href);
            throw new JiraHomeException(plainText, htmlText);
        }
        return home;
    }

    private boolean findDirectory(File directoryToTraverse, File directoryToFind) {
        for (File currentDirectory = directoryToTraverse; currentDirectory != null; currentDirectory = currentDirectory.getParentFile()) {
            if (!currentDirectory.equals(directoryToFind)) continue;
            return true;
        }
        return false;
    }

    private File validateJiraHome(String jiraHome) throws JiraHomeException {
        ServletContext servletContext;
        File proposedJiraHome = new File(jiraHome);
        if (!proposedJiraHome.isAbsolute()) {
            if (JiraSystemProperties.isDevMode()) {
                log.warn((Object)"jira.home is a relative path, but jira.dev.mode is set to true so we will allow this.");
            } else {
                HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath("jirahome");
                String s = "jira.home must be an absolute path.\nSee %s for instructions on setting jira.home";
                StringBuffer plainText = new StringBuffer(String.format("jira.home must be an absolute path.\nSee %s for instructions on setting jira.home", helpPath.getUrl()));
                String href = String.format("<a href=\"%s\">%s</a>", helpPath.getUrl(), TextUtils.htmlEncode((String)helpPath.getTitle()));
                StringBuffer htmlText = new StringBuffer(String.format(TextUtils.htmlEncode((String)"jira.home must be an absolute path.\nSee %s for instructions on setting jira.home"), href));
                plainText.append("\nYour current jira.home is:\n");
                plainText.append(jiraHome);
                boolean deadlyBackslash = System.getProperty("file.separator").equals("\\");
                if (deadlyBackslash) {
                    plainText.append("\n");
                    plainText.append("It looks like you are on Windows. This is usually caused by incorrect use of backslashes inside of jira-application.properties.\n");
                    plainText.append("Use forward slashes (/) instead.");
                }
                throw new JiraHomeException(plainText.toString(), htmlText.toString());
            }
        }
        if ((servletContext = ServletContextProvider.getServletContext()) == null) {
            log.error((Object)"No ServletContext exists - cannot check if jira.home is on the servlet path.");
        } else {
            File webappServletPath = new File(servletContext.getRealPath("/"));
            if (proposedJiraHome.equals(webappServletPath)) {
                throw new JiraHomeException("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' must not be the same as the webapp servlet path '" + webappServletPath.getAbsolutePath() + "'");
            }
            if (this.findDirectory(webappServletPath, proposedJiraHome)) {
                throw new JiraHomeException("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' must not be a parent directory of the webapp servlet path '" + webappServletPath.getAbsolutePath() + "'");
            }
            if (this.findDirectory(proposedJiraHome, webappServletPath)) {
                throw new JiraHomeException("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' must not be a directory within the webapp servlet path '" + webappServletPath.getAbsolutePath() + "'");
            }
        }
        if (proposedJiraHome.exists()) {
            if (!proposedJiraHome.isDirectory()) {
                String message = "Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' is not a directory.";
                throw new JiraHomeException(message);
            }
        } else {
            log.info((Object)("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' does not exist. We will create it."));
            try {
                if (!proposedJiraHome.mkdirs()) {
                    String jiraHomeURL = HelpUtil.getInstance().getHelpPath("jirahome").getUrl();
                    throw new JiraHomeException("Could not create jira.home directory '" + proposedJiraHome.getAbsolutePath() + "'. Please see " + jiraHomeURL + " for more information on how to set up your JIRA home directory.");
                }
            }
            catch (SecurityException ex) {
                String jiraHomeURL = HelpUtil.getInstance().getHelpPath("jirahome").getUrl();
                throw new JiraHomeException("Could not create jira.home directory '" + proposedJiraHome.getAbsolutePath() + "'. A Security Exception occured. Please see " + jiraHomeURL + " for more information on how to set up your JIRA home directory.");
            }
        }
        try {
            this.createAllHomeDirectories(proposedJiraHome);
        }
        catch (SecurityException ex) {
            String jiraHomeURL = HelpUtil.getInstance().getHelpPath("jirahome").getUrl();
            throw new JiraHomeException("Could not create jira.home directory '" + proposedJiraHome.getAbsolutePath() + "'. A Security Exception occured. Please see " + jiraHomeURL + " for more information on how to set up your JIRA home directory.");
        }
        this.lockJiraHome(proposedJiraHome);
        log.info((Object)("The jira.home directory '" + proposedJiraHome.getAbsolutePath() + "' is validated and locked for exclusive use by this instance."));
        return proposedJiraHome;
    }

    void createAllHomeDirectories(File proposedJiraHome) throws JiraHomeException {
        SortedSet<String> subdirs = CollectionBuilder.newBuilder().add(IndexPathManager.INDEXES_DIR).add(AttachmentPathManager.ATTACHMENTS_DIR).add("plugins").add(PluginPath.BUNDLED_SUBDIR).add(PluginPath.INSTALLED_PLUGINS_SUBDIR).add(PluginPath.OSGI_SUBDIR).add(FileService.MAIL_DIR).addAll((Collection<String>)JiraHome.subdirs).asMutableSortedSet();
        for (String subdir : subdirs) {
            try {
                File dir = new File(proposedJiraHome, subdir);
                if (dir.exists() || dir.mkdirs()) continue;
                String s = String.format("Could not create necessary subdirectory '%1$s' of jira.home.", subdir);
                throw new JiraHomeException(s);
            }
            catch (JiraHomeException homeException) {
                throw homeException;
            }
            catch (Exception e) {
                String s = String.format("Could not create necessary subdirectory '%1$s' of jira.home.", subdir);
                throw new JiraHomeException(s + "\n" + e.getMessage());
            }
        }
    }

    private void lockJiraHome(File proposedJiraHome) throws JiraHomeException {
        Assertions.notNull("You should not be in this method if you have a null lockAcquirer", this.lockAcquirer);
        String jiraHomePath = null;
        try {
            jiraHomePath = proposedJiraHome.getCanonicalPath();
        }
        catch (IOException e) {
            log.debug((Object)"Couldn't obtain canonical path for jira.home", (Throwable)e);
            jiraHomePath = proposedJiraHome.getAbsolutePath();
        }
        String failMsg = "Unable to create and acquire lock file for jira.home directory '" + jiraHomePath + "'.";
        try {
            JiraHomeLockAcquirer.LockResult result = this.lockAcquirer.acquire(proposedJiraHome);
            if (result != JiraHomeLockAcquirer.LockResult.OK) {
                if (result == JiraHomeLockAcquirer.LockResult.HELD_BY_OTHERS) {
                    String s = "The jira.home directory '%s' is already locked by another running instance of JIRA.";
                    String htmlText = String.format(TextUtils.htmlEncode((String)"The jira.home directory '%s' is already locked by another running instance of JIRA."), TextUtils.htmlEncode((String)jiraHomePath));
                    String plainText = "The jira.home directory '" + jiraHomePath + "' is already locked by another running instance of JIRA.";
                    throw new JiraHomeException(plainText, htmlText);
                }
                throw new JiraHomeException(failMsg);
            }
        }
        catch (JiraHomeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)(failMsg + " " + ex.getMessage()), (Throwable)ex);
            throw new JiraHomeException(failMsg);
        }
    }

    @Override
    public void stop() {
        this.lockAcquirer.release();
    }

    @Override
    public String getFaultDescription() {
        return this.faultDescription;
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.faultDescriptionHtml;
    }

    public File getJiraHomeDirectory() {
        return this.jiraHomeDirectory;
    }

    public String toString() {
        return this.getName();
    }
}

