/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.startup.JiraStartupState;
import com.atlassian.jira.startup.RunningStartupState;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.StartupStateTemplate;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.AtomicReference;

public class BootstrappingStartupState
extends StartupStateTemplate
implements JiraStartupState {
    private static final ImmutableList<StartupCheck> STARTUP_CHECKS = ImmutableList.of((Object)JiraHomeStartupCheck.getInstance());
    private final AtomicReference<JiraStartupState> currentState;

    public BootstrappingStartupState(AtomicReference<JiraStartupState> currentState) {
        this.currentState = currentState;
    }

    @Override
    public void onPluginSystemStarted() throws IllegalStateException {
        this.currentState.set(new RunningStartupState(this, this.currentState));
    }

    @Override
    public void onPluginSystemStopped() {
        throw new IllegalStateException("onPluginSystemStopped() called before onPluginSystemStarted()");
    }

    @Override
    public void onPluginSystemRestarted() {
        throw new IllegalStateException("onPluginSystemRestarted() called before onPluginSystemStarted()");
    }

    @Override
    public void onJiraStopping() {
        for (StartupCheck startupCheck : STARTUP_CHECKS) {
            startupCheck.stop();
        }
        this.currentState.set(new BootstrappingStartupState(this.currentState));
    }

    @Override
    protected ImmutableList<StartupCheck> getStartupChecks() {
        return STARTUP_CHECKS;
    }
}

