/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.soap.axis;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.rpc.SoapModuleDescriptor;
import com.atlassian.jira.soap.axis.JiraAxisSoapService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.DefaultAxisServerFactory;
import org.apache.log4j.Logger;

public class JiraAxisServerFactory
extends DefaultAxisServerFactory {
    private static final Logger log = Logger.getLogger(JiraAxisServerFactory.class);

    public AxisServer getServer(Map environment) throws AxisFault {
        EngineConfiguration defaultConfig = null;
        if (environment != null) {
            try {
                defaultConfig = (EngineConfiguration)environment.get("engineConfig");
            }
            catch (ClassCastException e) {
                log.warn((Object)e, (Throwable)e);
            }
        } else {
            environment = new HashMap<String, SimpleProvider>();
        }
        SimpleProvider newConfig = new SimpleProvider(defaultConfig);
        List soapDescriptors = ComponentAccessor.getPluginAccessor().getEnabledModuleDescriptorsByClass(SoapModuleDescriptor.class);
        Iterator iterator = soapDescriptors.iterator();
        while (iterator.hasNext()) {
            try {
                SoapModuleDescriptor descriptor = (SoapModuleDescriptor)iterator.next();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Publishing to " + descriptor.getServicePath() + " module " + descriptor.getModuleClass() + " with interface " + descriptor.getPublishedInterface()));
                }
                JiraAxisSoapService soapService = new JiraAxisSoapService(descriptor);
                newConfig.deployService(soapService.getName(), (SOAPService)soapService);
            }
            catch (Throwable e) {
                log.warn((Object)("Error registering soap service: " + e), e);
            }
        }
        environment.put("engineConfig", newConfig);
        return super.getServer(environment);
    }
}

