/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.config.util.EncodingConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;
import org.apache.velocity.exception.VelocityException;

public abstract class VelocityShareTypeRenderer
implements ShareTypeRenderer {
    private static final String I18N_KEY = "i18n";
    private static final String RENDERER_KEY = "renderer";
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/jira/sharing/";
    private final EncodingConfiguration encoding;
    private final VelocityManager velocityManager;

    public VelocityShareTypeRenderer(EncodingConfiguration encoding, VelocityManager velocityManager) {
        Assertions.notNull("encoding", encoding);
        Assertions.notNull("velocityManager", velocityManager);
        this.encoding = encoding;
        this.velocityManager = velocityManager;
    }

    protected final String renderVelocity(String template, Map<String, ?> params, JiraAuthenticationContext authenticationContext) {
        Map<String, ?> velocityParams = this.addDefaultVelocityParameters(params, authenticationContext);
        velocityParams.put(RENDERER_KEY, this);
        if (!velocityParams.containsKey(I18N_KEY)) {
            velocityParams.put(I18N_KEY, authenticationContext.getI18nHelper());
        }
        try {
            return this.velocityManager.getEncodedBody(TEMPLATE_DIRECTORY_PATH, template, this.encoding.getEncoding(), velocityParams);
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
    }

    Map<String, ?> addDefaultVelocityParameters(Map<String, ?> params, JiraAuthenticationContext authCtx) {
        return JiraVelocityUtils.getDefaultVelocityParams(params, authCtx);
    }
}

