/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.util.dbc.Assertions;

public class ProjectShareTypePermissionChecker
implements ShareTypePermissionChecker {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final ProjectRoleManager projectRoleManager;

    public ProjectShareTypePermissionChecker(ProjectManager projectManager, PermissionManager permissionManager, ProjectRoleManager projectRoleManager) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectRoleManager = projectRoleManager;
    }

    @Override
    public boolean hasPermission(User user, SharePermission permission) {
        Assertions.notNull("permission", permission);
        Assertions.equals(ProjectShareType.TYPE.toString(), ProjectShareType.TYPE, permission.getType());
        Assertions.notNull("permission.param1", permission.getParam1());
        Long projectId = new Long(permission.getParam1());
        Project project = this.projectManager.getProjectObj(projectId);
        if (project == null) {
            return false;
        }
        if (permission.getParam2() == null) {
            return this.permissionManager.hasPermission(10, project, user);
        }
        if (user != null) {
            Long roleId = new Long(permission.getParam2());
            ProjectRole role = this.projectRoleManager.getProjectRole(roleId);
            return role != null && this.projectRoleManager.isUserInProjectRole(user, role, project);
        }
        return false;
    }
}

