/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleComparator;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.DefaultSharePermissionComparator;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.util.dbc.Assertions;

public class ProjectSharePermissionComparator
extends DefaultSharePermissionComparator {
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;

    public ProjectSharePermissionComparator(ProjectManager projectManager, ProjectRoleManager projectRoleManager) {
        super(ProjectShareType.TYPE);
        Assertions.notNull("projectManager", projectManager);
        Assertions.notNull("projectRoleManager", projectRoleManager);
        this.projectManager = projectManager;
        this.projectRoleManager = projectRoleManager;
    }

    @Override
    public int comparePermissions(SharePermission perm1, SharePermission perm2) {
        Project project2;
        Project project1;
        int compareResult = ProjectSharePermissionComparator.compareNull(perm1.getParam1(), perm2.getParam1());
        if (compareResult == 0 && perm1.getParam1() != null && (compareResult = ProjectNameComparator.COMPARATOR.compare(project1 = this.projectManager.getProjectObj(new Long(perm1.getParam1())), project2 = this.projectManager.getProjectObj(new Long(perm2.getParam1())))) == 0 && (compareResult = ProjectSharePermissionComparator.compareNull(perm1.getParam2(), perm2.getParam2())) == 0 && perm1.getParam2() != null) {
            ProjectRole role1 = this.projectRoleManager.getProjectRole(new Long(perm1.getParam2()));
            ProjectRole role2 = this.projectRoleManager.getProjectRole(new Long(perm2.getParam2()));
            compareResult = ProjectRoleComparator.COMPARATOR.compare(role1, role2);
        }
        return compareResult;
    }
}

