/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.GroupShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang.StringUtils;

public class GroupShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;
    private final GroupManager groupManager;

    public GroupShareTypeValidator(PermissionManager permissionManager, GroupManager groupManager) {
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
    }

    @Override
    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull("ctx", ctx);
        Assertions.notNull("ctx.user", ctx.getLoggedInUser());
        Assertions.notNull("permission", permission);
        Assertions.equals(GroupShareType.TYPE.toString(), GroupShareType.TYPE, permission.getType());
        boolean hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInUser());
        if (!hasPermission) {
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        } else if (StringUtils.isBlank((String)permission.getParam1())) {
            String groupName = permission.getParam1() == null ? "" : permission.getParam1();
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.not.valid", groupName));
        } else {
            Group group = this.getGroup(permission.getParam1());
            if (group == null) {
                ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.does.not.exist", permission.getParam1()));
            } else if (!this.groupManager.isUserInGroup(ctx.getLoggedInUser(), group)) {
                String userName = ctx.getLoggedInUser() != null ? ctx.getLoggedInUser().getDisplayName() : ctx.getI18nBean().getText("common.words.Anonymous");
                ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.not.in.group", permission.getParam1()));
                ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.not.in.group", userName, permission.getParam1()));
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    @Override
    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull("ctx", ctx);
        Assertions.notNull("searchParameter", searchParameter);
        Assertions.equals(GroupShareType.TYPE.toString(), GroupShareType.TYPE, searchParameter.getType());
        if (ctx.getLoggedInUser() == null) {
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.searching.exception.anonymous.group.search"));
        } else {
            GroupShareTypeSearchParameter groupShareTypeSearchParameter = (GroupShareTypeSearchParameter)searchParameter;
            String groupName = groupShareTypeSearchParameter.getGroupName();
            if (StringUtils.isNotBlank((String)groupName)) {
                Group group = this.getGroup(groupName);
                if (group == null) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.does.not.exist", groupName));
                } else if (!this.groupManager.isUserInGroup(ctx.getLoggedInUser(), group)) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.searching.exception.not.in.group", groupName));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.not.in.group", ctx.getLoggedInUser().getDisplayName(), groupName));
                }
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    Group getGroup(String groupName) {
        return this.groupManager.getGroup(groupName);
    }
}

