/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.GlobalShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;

public class GlobalShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;

    public GlobalShareTypeValidator(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull("ctx", ctx);
        Assertions.notNull("ctx.user", ctx.getLoggedInUser());
        Assertions.notNull("permission", permission);
        Assertions.equals(GlobalShareType.TYPE.toString(), GlobalShareType.TYPE, permission.getType());
        boolean hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInUser());
        if (!hasPermission) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        }
        return hasPermission;
    }

    @Override
    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull("ctx", ctx);
        Assertions.notNull("searchParameter", searchParameter);
        Assertions.equals(GlobalShareType.TYPE.toString(), GlobalShareType.TYPE, searchParameter.getType());
        return true;
    }
}

