/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.GlobalShareType;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class GlobalShareTypeRenderer
implements ShareTypeRenderer {
    @Override
    public String renderPermission(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull("permission", permission);
        Assertions.notNull("authenticationContext", authenticationContext);
        Assertions.equals("permission-type", GlobalShareType.TYPE, permission.getType());
        return this.getText(authenticationContext, "common.sharing.shared.template.everyone");
    }

    @Override
    public String getSimpleDescription(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull("permission", permission);
        Assertions.notNull("authenticationContext", authenticationContext);
        Assertions.equals("permission-type", GlobalShareType.TYPE, permission.getType());
        return this.getText(authenticationContext, "common.sharing.shared.display.everyone.desc");
    }

    @Override
    public String getShareTypeEditor(JiraAuthenticationContext authenticationContext) {
        return "";
    }

    @Override
    public boolean isAddButtonNeeded(JiraAuthenticationContext userCtx) {
        return true;
    }

    @Override
    public String getShareTypeLabel(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull("authenticationContext", authenticationContext);
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.description.everyone");
    }

    @Override
    public Map<String, String> getTranslatedTemplates(JiraAuthenticationContext authenticationContext, SharedEntity.TypeDescriptor<? extends SharedEntity> type, ShareTypeRenderer.RenderMode mode) {
        Assertions.notNull("authenticationContext", authenticationContext);
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("share_global_display", StringEscapeUtils.escapeJavaScript((String)this.getText(authenticationContext, "common.sharing.shared.template.everyone")));
        templates.put("share_global_description", StringEscapeUtils.escapeJavaScript((String)this.getText(authenticationContext, "common.sharing.shared.template.everyone.desc")));
        templates.put("share_global_warning", StringEscapeUtils.escapeJavaScript((String)this.getText(authenticationContext, "common.sharing.shared.template.everyone.warning")));
        return Collections.unmodifiableMap(templates);
    }

    private String getText(JiraAuthenticationContext ctx, String key) {
        return ctx.getI18nHelper().getText(key);
    }
}

