/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.lucene.document.Field;

public interface SharedEntityFieldFactory {
    public String getFieldName();

    public Collection<Field> getField(SharedEntity var1);

    @Immutable
    public static abstract class Default
    implements SharedEntityFieldFactory {
        static final Default ID = new Default(SharedEntityColumnDefinition.ID.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getId().toString();
            }
        };
        static final Default NAME = new Default(SharedEntityColumnDefinition.NAME.getName()){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getName();
            }
        };
        static final Default NAME_CASE_INSENSITIVE = new Default(SharedEntityColumnDefinition.NAME.getCaseInsensitiveColumn(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS){

            @Override
            String getValue(SharedEntity entity) {
                String result = entity.getName();
                return result == null ? null : result.toLowerCase();
            }
        };
        static final Default NAME_SORT = new Default(SharedEntityColumnDefinition.NAME.getSortColumn(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS){

            @Override
            String getValue(SharedEntity entity) {
                String result = entity.getName();
                return result == null ? null : FieldIndexerUtil.getValueForSorting(result.toLowerCase());
            }
        };
        static final Default DESCRIPTION = new Default(SharedEntityColumnDefinition.DESCRIPTION.getName()){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getDescription();
            }
        };
        static final Default DESCRIPTION_SORT = new Default(SharedEntityColumnDefinition.DESCRIPTION.getSortColumn()){

            @Override
            String getValue(SharedEntity entity) {
                String result = entity.getDescription();
                return result == null ? null : FieldIndexerUtil.getValueForSorting(result.toLowerCase());
            }
        };
        static final Default OWNER = new Default(SharedEntityColumnDefinition.OWNER.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS){

            @Override
            String getValue(SharedEntity entity) {
                return entity.getOwnerUserName();
            }
        };
        static final Default FAVOURITE_COUNT = new Default(SharedEntityColumnDefinition.FAVOURITE_COUNT.getName()){

            @Override
            String getValue(SharedEntity entity) {
                return String.valueOf(entity.getFavouriteCount());
            }
        };
        static final List<Default> BUILDERS = Collections.unmodifiableList(Lists.newArrayList((Object[])new Default[]{ID, NAME, NAME_SORT, NAME_CASE_INSENSITIVE, DESCRIPTION, DESCRIPTION_SORT, OWNER, FAVOURITE_COUNT}));
        private final String fieldName;
        private final Field.Store store;
        private final Field.Index index;

        protected Default(String fieldName) {
            this(fieldName, Field.Store.YES, Field.Index.ANALYZED);
        }

        protected Default(String fieldName, Field.Store store, Field.Index index) {
            this.fieldName = fieldName;
            this.index = index;
            this.store = store;
        }

        @Override
        public Collection<Field> getField(SharedEntity entity) {
            String value = this.getValue(entity);
            value = value == null ? "" : value;
            return Collections.singleton(new Field(this.fieldName, value, this.store, this.index));
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        abstract String getValue(SharedEntity var1);
    }
}

