/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.SharedEntityFieldFactory;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.PrivateShareQueryFactory;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.document.Field;

public class ShareTypePermissionsFieldFactory
implements SharedEntityFieldFactory {
    static final PrivateShareQueryFactory PRIVATE = new PrivateShareQueryFactory(){};
    private final ShareTypeFactory shareTypeFactory;

    public ShareTypePermissionsFieldFactory(ShareTypeFactory shareTypeFactory) {
        this.shareTypeFactory = shareTypeFactory;
    }

    @Override
    public String getFieldName() {
        return null;
    }

    @Override
    public Collection<Field> getField(SharedEntity entity) {
        SharedEntity.SharePermissions permissions = entity.getPermissions();
        if (permissions.isPrivate()) {
            return ImmutableList.of((Object)PRIVATE.getField(entity, null));
        }
        ArrayList<Field> result = new ArrayList<Field>(permissions.size());
        for (SharePermission permission : permissions) {
            ShareType shareType = this.shareTypeFactory.getShareType(permission.getType());
            Assertions.notNull("shareType", shareType);
            ShareQueryFactory<? extends ShareTypeSearchParameter> queryFactory = shareType.getQueryFactory();
            result.add(queryFactory.getField(entity, permission));
        }
        return result;
    }

    static interface PermissionFieldFactory {
        public Field getField();
    }
}

