/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.SharedEntityFieldFactory;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.lucene.document.Field;

public class IsSharedFieldFactory
implements SharedEntityFieldFactory {
    private static final String IS_SHARED_FIELD_NAME = "isShared";

    @Override
    public String getFieldName() {
        return IS_SHARED_FIELD_NAME;
    }

    @Override
    public Collection<Field> getField(SharedEntity entity) {
        return ImmutableList.of((Object)new Field(IS_SHARED_FIELD_NAME, String.valueOf(this.isShared(entity)), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
    }

    private boolean isShared(SharedEntity entity) {
        boolean isSystemDashboard = false;
        if (entity.getEntityType().equals(PortalPage.ENTITY_TYPE)) {
            isSystemDashboard = ((PortalPage)entity).isSystemDefaultPortalPage();
        }
        return !entity.getPermissions().isPrivate() && !isSystemDashboard;
    }
}

