/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.DirectoryFactory;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import org.apache.lucene.store.Directory;

public class IndexPathDirectoryFactory
implements DirectoryFactory {
    private final IndexPathManager pathManager;
    private final LuceneDirectoryUtils luceneDirectoryUtils;

    public IndexPathDirectoryFactory(IndexPathManager pathManager, LuceneDirectoryUtils luceneDirectoryUtils) {
        this.luceneDirectoryUtils = Assertions.notNull("luceneDirectoryUtils", luceneDirectoryUtils);
        this.pathManager = Assertions.notNull("path", pathManager);
    }

    @Override
    public Directory get(SharedEntity.TypeDescriptor<?> type) {
        return this.luceneDirectoryUtils.getDirectory(new File(this.getIndexPath(type)));
    }

    String getIndexPath(SharedEntity.TypeDescriptor<?> type) {
        return this.pathManager.getSharedEntityIndexPath() + "/" + type.getName().toLowerCase();
    }
}

