/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.index.CompositeResultBuilder;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingStrategy;
import com.atlassian.jira.index.MultiThreadedIndexingConfiguration;
import com.atlassian.jira.index.MultiThreadedIndexingStrategy;
import com.atlassian.jira.index.SimpleIndexingStrategy;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.RuntimeInterruptedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DefaultSharedEntityIndexManager
implements SharedEntityIndexManager {
    private static final MultiThreadedIndexingConfiguration multiThreadedIndexingConfiguration = new MultiThreadedIndexingConfiguration(){

        @Override
        public int minimumBatchSize() {
            return 50;
        }

        @Override
        public int maximumQueueSize() {
            return 1000;
        }

        @Override
        public int noOfThreads() {
            return 20;
        }
    };
    private final SharedEntityIndexer indexer;
    private final FileFactory fileFactory;
    private final IndexingStrategy simpleIndexingStrategy = new SimpleIndexingStrategy();
    private final SharedEntity.TypeDescriptor<?>[] types = new SharedEntity.TypeDescriptor[]{SearchRequest.ENTITY_TYPE, PortalPage.ENTITY_TYPE};
    private final Map<SharedEntity.TypeDescriptor<?>, Retriever<? extends SharedEntity>> retrievers;

    public DefaultSharedEntityIndexManager(SharedEntityIndexer indexer, final SearchRequestManager searchRequestManager, final PortalPageManager portalPageManager, FileFactory fileFactory) {
        this.indexer = indexer;
        this.fileFactory = fileFactory;
        LinkedHashMap<SharedEntity.TypeDescriptor<SharedEntity>, Retriever<SharedEntity>> retrievers = new LinkedHashMap<SharedEntity.TypeDescriptor<SharedEntity>, Retriever<SharedEntity>>(this.types.length);
        retrievers.put(SearchRequest.ENTITY_TYPE, new Retriever<SharedEntity>(){

            @Override
            public EnclosedIterable<SharedEntity> getAll() {
                return searchRequestManager.getAllIndexableSharedEntities();
            }
        });
        retrievers.put(PortalPage.ENTITY_TYPE, new Retriever<SharedEntity>(){

            @Override
            public EnclosedIterable<SharedEntity> getAll() {
                return portalPageManager.getAllIndexableSharedEntities();
            }
        });
        this.retrievers = Collections.unmodifiableMap(retrievers);
    }

    @Override
    public long reIndexAll(Context context) {
        Assertions.notNull("event", context);
        long result = 0L;
        for (Map.Entry<SharedEntity.TypeDescriptor<?>, Retriever<SharedEntity>> entry : this.retrievers.entrySet()) {
            this.indexer.recreate(entry.getKey());
            result += this.reIndex(context, entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends SharedEntity> long reIndex(final Context context, SharedEntity.TypeDescriptor<?> type, Retriever<S> retriever) {
        context.setName(type.getName());
        long start = System.currentTimeMillis();
        EnclosedIterable<S> all = retriever.getAll();
        final IndexingStrategy strategy = this.getStrategy(all.size());
        try {
            final CompositeResultBuilder builder = new CompositeResultBuilder();
            all.foreach(new Consumer<S>(){

                @Override
                public void consume(final S entity) {
                    final Context.Task task = context.start(entity);
                    builder.add((Index.Result)strategy.get(new Supplier<Index.Result>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Index.Result get() {
                            try {
                                Index.Result result = DefaultSharedEntityIndexManager.this.indexer.index(entity);
                                return result;
                            }
                            finally {
                                task.complete();
                            }
                        }
                    }));
                }
            });
            builder.toResult().await();
            long l = System.currentTimeMillis() - start;
            return l;
        }
        finally {
            strategy.close();
        }
    }

    private <S> IndexingStrategy getStrategy(int count) {
        if (count < multiThreadedIndexingConfiguration.minimumBatchSize()) {
            return this.simpleIndexingStrategy;
        }
        return new MultiThreadedIndexingStrategy(this.simpleIndexingStrategy, multiThreadedIndexingConfiguration, "SharedEntityIndexer");
    }

    public long reIndexAll() throws IndexException {
        return this.reIndexAll(Contexts.nullContext());
    }

    @Override
    public long optimize() {
        long result = 0L;
        for (SharedEntity.TypeDescriptor<?> type : this.types) {
            result += this.indexer.optimize(type);
        }
        return result;
    }

    @Override
    public void shutdown() {
        for (SharedEntity.TypeDescriptor<?> type : this.types) {
            this.indexer.shutdown(type);
        }
    }

    @Override
    public long activate(Context context) {
        Assertions.notNull("event", context);
        return this.reIndexAll(context);
    }

    @Override
    public void deactivate() {
        for (SharedEntity.TypeDescriptor<?> type : this.types) {
            this.clear(type);
        }
    }

    @Override
    public boolean isIndexingEnabled() {
        return true;
    }

    @Override
    public Collection<String> getAllIndexPaths() {
        return this.indexer.getAllIndexPaths();
    }

    @Override
    public int size() {
        return this.sum(this.sizes());
    }

    @Override
    public boolean isEmpty() {
        for (Retriever<? extends SharedEntity> element : this.retrievers.values()) {
            if (element.getAll().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private int sum(int[] ints) {
        int result = 0;
        for (int j : ints) {
            result += j;
        }
        return result;
    }

    private int[] sizes() {
        int[] sizes = new int[this.retrievers.size()];
        int i = 0;
        for (Retriever<? extends SharedEntity> element : this.retrievers.values()) {
            sizes[i++] = element.getAll().size();
        }
        return sizes;
    }

    public String toString() {
        return "SharedEntityIndexManager: paths: " + this.getAllIndexPaths();
    }

    private void clear(SharedEntity.TypeDescriptor<?> type) {
        this.fileFactory.removeDirectoryIfExists(this.indexer.clear(type));
    }

    static final class CompositeResult
    implements Index.Result {
        private final BlockingQueue<Index.Result> results;
        private final CountDownLatch latch;

        public CompositeResult(int size) {
            this.results = new LinkedBlockingQueue<Index.Result>(size);
            this.latch = new CountDownLatch(size);
        }

        void add(Index.Result result) {
            this.results.add(result);
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        @Override
        public void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            try {
                return this.latch.await(timeout, unit);
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }

        void clearDone() {
            Iterator it = this.results.iterator();
            while (it.hasNext()) {
                if (!((Index.Result)it.next()).isDone()) continue;
                this.latch.countDown();
                it.remove();
            }
        }
    }

    static interface Retriever<S extends SharedEntity> {
        public EnclosedIterable<S> getAll();
    }
}

