/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.utils.StringUtils;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.atlassian.jira.sharing.index.QueryBuilder;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.index.SharedEntitySearchContextToQueryFactoryMap;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public class DefaultQueryFactory
implements QueryFactory {
    private final ShareTypeFactory shareTypeFactory;
    private final Map<SharedEntitySearchContext, QueryFactory> searchContextToQueryFactoryMap;

    public DefaultQueryFactory(ShareTypeFactory shareTypeFactory, SharedEntitySearchContextToQueryFactoryMap searchContextToQueryFactoryMap) {
        this.shareTypeFactory = shareTypeFactory;
        this.searchContextToQueryFactoryMap = searchContextToQueryFactoryMap;
    }

    @Override
    public Query create(SharedEntitySearchParameters params, final User user) {
        QueryBuilder builder = new Builder(params){

            @Override
            void add(ShareTypeSearchParameter shareTypeSearchParameter, BooleanClause.Occur occurance) {
                if (shareTypeSearchParameter != null) {
                    this.add(DefaultQueryFactory.this.shareTypeFactory.getShareType(shareTypeSearchParameter.getType()).getQueryFactory().getQuery(shareTypeSearchParameter, user), occurance);
                }
            }
        }.build();
        builder.add(this.getQueryFactoryFor(params.getEntitySearchContext()).create(params, user), BooleanClause.Occur.MUST);
        return builder.toQuery();
    }

    private QueryFactory getQueryFactoryFor(SharedEntitySearchContext searchContext) {
        return this.searchContextToQueryFactoryMap.get((Object)searchContext);
    }

    @Override
    public Query create(SharedEntitySearchParameters params) {
        return new Builder(params){

            @Override
            void add(ShareTypeSearchParameter shareTypeSearchParameter, BooleanClause.Occur occurance) {
                if (shareTypeSearchParameter != null) {
                    this.add(DefaultQueryFactory.this.shareTypeFactory.getShareType(shareTypeSearchParameter.getType()).getQueryFactory().getQuery(shareTypeSearchParameter), occurance);
                }
            }
        }.build().toQuery();
    }

    private abstract class Builder
    extends QueryBuilder {
        private final SharedEntitySearchParameters params;

        private Builder(SharedEntitySearchParameters params) {
            this.params = params;
        }

        @Override
        QueryBuilder build() {
            QueryBuilder nameOrDescription = new QueryBuilder();
            if (this.params.getTextSearchMode() == SharedEntitySearchParameters.TextSearchMode.EXACT) {
                if (!StringUtils.isBlank((String)this.params.getName())) {
                    nameOrDescription.add(new Term(SharedEntityColumnDefinition.NAME.getCaseInsensitiveColumn(), this.params.getName().toLowerCase()), BooleanClause.Occur.MUST);
                }
                if (!StringUtils.isBlank((String)this.params.getDescription())) {
                    nameOrDescription.add(new Term(SharedEntityColumnDefinition.DESCRIPTION.getSortColumn(), FieldIndexerUtil.getValueForSorting(this.params.getDescription().toLowerCase())), BooleanClause.Occur.MUST);
                }
            } else if (this.params.getTextSearchMode() == SharedEntitySearchParameters.TextSearchMode.WILDCARD) {
                this.addParsedWildcardQueries(nameOrDescription, BooleanClause.Occur.SHOULD);
            } else {
                BooleanClause.Occur clauseOccurence = this.params.getTextSearchMode() == SharedEntitySearchParameters.TextSearchMode.OR ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                this.addParsedQueries(nameOrDescription, clauseOccurence);
            }
            this.add(nameOrDescription, BooleanClause.Occur.MUST);
            this.add(SharedEntityColumn.OWNER, this.params.getUserName(), BooleanClause.Occur.MUST);
            this.add(this.params.getShareTypeParameter(), BooleanClause.Occur.MUST);
            return this;
        }

        private void addParsedQueries(QueryBuilder nameOrDescription, BooleanClause.Occur clauseOccurence) {
            nameOrDescription.addParsedQuery(SharedEntityColumn.NAME, this.params.getName(), clauseOccurence);
            nameOrDescription.addParsedQuery(SharedEntityColumn.DESCRIPTION, this.params.getDescription(), clauseOccurence);
        }

        private void addParsedWildcardQueries(QueryBuilder nameOrDescription, BooleanClause.Occur clauseOccurence) {
            nameOrDescription.addParsedWildcardQuery(SharedEntityColumn.NAME, this.params.getName(), clauseOccurence);
            nameOrDescription.addParsedWildcardQuery(SharedEntityColumn.DESCRIPTION, this.params.getDescription(), clauseOccurence);
        }

        abstract void add(ShareTypeSearchParameter var1, BooleanClause.Occur var2);
    }
}

