/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.issue.statistics.AssigneeStatisticsMapper;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.concurrent.Immutable;
import org.apache.lucene.search.FieldComparatorSource;

@Immutable
public class SharedEntityColumnDefinition {
    public static final SharedEntityColumnDefinition ID = new SharedEntityColumnDefinition("id", 4);
    public static final SharedEntityColumnDefinition NAME = new SharedEntityColumnDefinition("name", "nameSort", "nameCaseless", 3);
    public static final SharedEntityColumnDefinition DESCRIPTION = new SharedEntityColumnDefinition("description", "descriptionSort", 3);
    public static final SharedEntityColumnDefinition OWNER = new SharedEntityColumnDefinition("owner", new SortComparatorFactory(){

        @Override
        public FieldComparatorSource getSortComparator() {
            return new MappedSortComparator(ComponentManager.getComponentInstanceOfType(AssigneeStatisticsMapper.class));
        }
    });
    public static final SharedEntityColumnDefinition FAVOURITE_COUNT = new SharedEntityColumnDefinition("favouriteCount", 4);
    public static final SharedEntityColumnDefinition IS_SHARED = new SharedEntityColumnDefinition("isShared", 3);
    private final String name;
    private final String sortColumn;
    private final String caseInsensitiveColumn;
    private final int sortType;
    private final SortComparatorFactory sortComparatorFactory;

    private SharedEntityColumnDefinition(String sortColumn, int sortType) {
        this(sortColumn, sortColumn, sortType);
    }

    private SharedEntityColumnDefinition(String name, String sortColumn, int sortType) {
        Assertions.notNull("sortColumn", sortColumn);
        this.name = name;
        this.sortColumn = sortColumn;
        this.caseInsensitiveColumn = null;
        this.sortType = sortType;
        this.sortComparatorFactory = null;
    }

    private SharedEntityColumnDefinition(String name, String sortColumn, String caseInsensitiveColumn, int sortType) {
        Assertions.notNull("sortColumn", sortColumn);
        this.name = name;
        this.sortColumn = sortColumn;
        this.sortType = sortType;
        this.caseInsensitiveColumn = caseInsensitiveColumn;
        this.sortComparatorFactory = null;
    }

    private SharedEntityColumnDefinition(String name, SortComparatorFactory sortComparatorFactory) {
        Assertions.notNull("sortColumn", name);
        this.name = name;
        this.sortComparatorFactory = sortComparatorFactory;
        this.caseInsensitiveColumn = null;
        this.sortColumn = name;
        this.sortType = 9;
    }

    public String getName() {
        return this.name;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public int getSortType() {
        return this.sortType;
    }

    public String getCaseInsensitiveColumn() {
        return this.caseInsensitiveColumn;
    }

    public boolean isCustomSort() {
        return this.sortComparatorFactory != null;
    }

    public FieldComparatorSource createSortComparator() {
        return this.sortComparatorFactory.getSortComparator();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedEntityColumnDefinition sortOrder = (SharedEntityColumnDefinition)o;
        return !(this.sortColumn != null ? !this.sortColumn.equals(sortOrder.sortColumn) : sortOrder.sortColumn != null);
    }

    public int hashCode() {
        return this.sortColumn != null ? this.sortColumn.hashCode() : 0;
    }

    public static SharedEntityColumnDefinition definitionFor(SharedEntityColumn column) {
        switch (column) {
            case ID: {
                return ID;
            }
            case NAME: {
                return NAME;
            }
            case DESCRIPTION: {
                return DESCRIPTION;
            }
            case OWNER: {
                return OWNER;
            }
            case FAVOURITE_COUNT: {
                return FAVOURITE_COUNT;
            }
        }
        throw new IllegalArgumentException("Unknown SharedEntityColumn " + (Object)((Object)column));
    }

    static interface SortComparatorFactory {
        public FieldComparatorSource getSortComparator();
    }
}

