/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class OfBizSharePermissionStore
implements SharePermissionStore {
    private final OfBizDelegator delegator;

    public OfBizSharePermissionStore(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        this.validate(entity);
        List<GenericValue> perms = this.delegator.findByAnd("SharePermissions", new PrimitiveMap.Builder().add("entityId", entity.getId()).add("entityType", entity.getEntityType().getName()).toMap());
        HashSet<SharePermissionImpl> returnPerms = new HashSet<SharePermissionImpl>(perms.size());
        for (GenericValue genericValue : perms) {
            returnPerms.add(this.convertGVToSharePermission(genericValue));
        }
        return new SharedEntity.SharePermissions(returnPerms);
    }

    @Override
    public int deleteSharePermissions(SharedEntity entity) {
        this.validate(entity);
        return this.delegator.removeByAnd("SharePermissions", new PrimitiveMap.Builder().add("entityId", entity.getId()).add("entityType", entity.getEntityType().getName()).toMap());
    }

    @Override
    public int deleteSharePermissionsLike(SharePermission permission) {
        Assertions.notNull("permission", permission);
        Assertions.notNull("permission.type", permission.getType());
        if (permission.getParam1() == null && permission.getParam2() == null) {
            throw new IllegalArgumentException("You must provide at least a non null param1 or param2");
        }
        PrimitiveMap.Builder params = new PrimitiveMap.Builder().add("type", permission.getType().get());
        if (permission.getParam1() != null) {
            params.add("param1", permission.getParam1());
        }
        if (permission.getParam2() != null) {
            params.add("param2", permission.getParam2());
        }
        return this.delegator.removeByAnd("SharePermissions", params.toMap());
    }

    @Override
    public SharedEntity.SharePermissions storeSharePermissions(SharedEntity entity) {
        this.validate(entity);
        SharedEntity.SharePermissions permissions = entity.getPermissions();
        Assertions.notNull("permissions", permissions);
        this.deleteSharePermissions(entity);
        HashSet<SharePermissionImpl> returnPermissions = new HashSet<SharePermissionImpl>();
        for (SharePermission permission : permissions) {
            GenericValue gv = this.delegator.createValue("SharePermissions", this.createMap(permission, entity));
            returnPermissions.add(this.convertGVToSharePermission(gv));
        }
        return new SharedEntity.SharePermissions(returnPermissions);
    }

    private void validate(SharedEntity entity) {
        Assertions.notNull("entity", entity);
        Assertions.notNull("entity.id", entity.getId());
        Assertions.notNull("entity.entityType", entity.getEntityType());
    }

    private Map<String, Object> createMap(SharePermission permission, SharedEntity entity) {
        PrimitiveMap.Builder builder = new PrimitiveMap.Builder();
        builder.add("entityId", entity.getId());
        builder.add("entityType", entity.getEntityType().getName());
        builder.add("type", permission.getType().get());
        builder.add("param1", permission.getParam1());
        builder.add("param2", permission.getParam2());
        return builder.toMap();
    }

    private SharePermissionImpl convertGVToSharePermission(GenericValue genericValue) {
        return new SharePermissionImpl(genericValue.getLong("id"), new ShareType.Name(genericValue.getString("type")), genericValue.getString("param1"), genericValue.getString("param2"));
    }

    private static final class Column {
        private static final String ENTITY_ID = "entityId";
        private static final String ENTITY_TYPE = "entityType";
        private static final String PARAM2 = "param2";
        private static final String PARAM1 = "param1";
        private static final String TYPE = "type";
        private static final String ID = "id";

        private Column() {
        }
    }

    private static final class Table {
        private static final String NAME = "SharePermissions";

        private Table() {
        }
    }
}

