/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.util.dbc.Assertions;

public class DefaultShareTypeValidatorUtils
implements ShareTypeValidatorUtils {
    private final ShareTypeFactory shareTypeFactory;
    private final PermissionManager permissionManager;

    public DefaultShareTypeValidatorUtils(ShareTypeFactory shareTypeFactory, PermissionManager permissionManager) {
        Assertions.notNull("shareTypeFactory", shareTypeFactory);
        Assertions.notNull("permissionManager", permissionManager);
        this.permissionManager = permissionManager;
        this.shareTypeFactory = shareTypeFactory;
    }

    @Override
    public boolean isValidSharePermission(JiraServiceContext context, SharedEntity entity) {
        Assertions.notNull("entity", entity);
        SharedEntity.SharePermissions permissions = entity.getPermissions();
        Assertions.notNull("permissions", permissions);
        if (!permissions.isPrivate()) {
            boolean hasPermission = this.permissionManager.hasPermission(22, context.getLoggedInUser());
            if (!hasPermission) {
                String userName = context.getLoggedInUser() != null ? context.getLoggedInUser().getDisplayName() : context.getI18nBean().getText("common.words.Anonymous");
                context.getErrorCollection().addError("shares", context.getI18nBean().getText("common.sharing.exception.no.share.permission"));
                context.getErrorCollection().addError("shares_delegated", context.getI18nBean().getText("common.sharing.exception.delegated.user.no.share.permission", userName));
                return false;
            }
            for (SharePermission sharePermission : permissions) {
                ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
                if (type == null) {
                    context.getErrorCollection().addError("shares", context.getI18nBean().getText("common.sharing.exception.unknown.type", sharePermission.getType()));
                    continue;
                }
                if (type.isSingleton() && permissions.size() > 1) {
                    context.getErrorCollection().addError("shares", context.getI18nBean().getText("common.sharing.exception.singleton", sharePermission.getType()));
                }
                type.getValidator().checkSharePermission(context, sharePermission);
            }
        }
        return context.getErrorCollection().hasAnyErrors();
    }

    @Override
    public boolean isValidSearchParameter(JiraServiceContext context, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull("context", context);
        Assertions.notNull("searchParameter", searchParameter);
        ShareType.Name shareType = searchParameter.getType();
        ShareType type = this.shareTypeFactory.getShareType(shareType);
        if (type == null) {
            context.getErrorCollection().addError("shares", context.getI18nBean().getText("common.sharing.exception.unknown.type", shareType));
            return false;
        }
        return type.getValidator().checkSearchParameter(context, searchParameter);
    }
}

