/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionReindexer;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Preconditions;

public class DefaultShareManager
implements ShareManager {
    private final SharePermissionStore store;
    private final ShareTypeFactory shareTypeFactory;
    private final SharePermissionReindexer reindexer;

    public DefaultShareManager(SharePermissionStore store, ShareTypeFactory shareTypeFactory, SharePermissionReindexer reindexer) {
        Preconditions.checkNotNull((Object)store, (Object)"Can not instantiate a ShareManager with a 'null' SharePermissionStore");
        Preconditions.checkNotNull((Object)shareTypeFactory, (Object)"Can not instantiate a ShareManager with a 'null' ShareTypeFactory");
        Preconditions.checkNotNull((Object)reindexer, (Object)"Can not instantiate a ShareManager with a 'null' SharePermissionReindexer");
        this.store = store;
        this.shareTypeFactory = shareTypeFactory;
        this.reindexer = reindexer;
    }

    @Override
    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        return this.store.getSharePermissions(entity);
    }

    @Override
    public void deletePermissions(SharedEntity entity) {
        this.store.deleteSharePermissions(entity);
    }

    @Override
    public void deleteSharePermissionsLike(SharePermission permission) {
        this.store.deleteSharePermissionsLike(permission);
        this.reindexer.reindex(permission);
    }

    @Override
    public SharedEntity.SharePermissions updateSharePermissions(SharedEntity entity) {
        Assertions.notNull("entity", entity);
        Assertions.notNull("entity.sharePermissions", entity.getPermissions());
        if (entity.getPermissions().isPrivate()) {
            this.store.deleteSharePermissions(entity);
            return SharedEntity.SharePermissions.PRIVATE;
        }
        return this.store.storeSharePermissions(entity);
    }

    @Override
    @Deprecated
    public boolean hasPermission(User user, SharedEntity entity) {
        return this.isSharedWith(user, entity);
    }

    @Override
    public boolean isSharedWith(User user, SharedEntity sharedEntity) {
        Assertions.notNull("entity", sharedEntity);
        if (sharedEntity.getOwnerUserName() != null && UserNames.equal(sharedEntity.getOwnerUserName(), user)) {
            return true;
        }
        SharedEntity.SharePermissions permissions = this.store.getSharePermissions(sharedEntity);
        if (permissions != null) {
            for (SharePermission sharePermission : permissions) {
                ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
                if (type == null || !type.getPermissionsChecker().hasPermission(user, sharePermission)) continue;
                return true;
            }
        }
        return false;
    }
}

