/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.servlet.BrowseProjectUrlHelper;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.util.profiling.UtilTimerStack;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class QuickLinkServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(QuickLinkServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block21: {
            UtilTimerStack.push((String)"QuickLinkServlet.service()");
            try {
                String pathInfo = request.getPathInfo();
                if (pathInfo == null || pathInfo.equals("") || pathInfo.equals("/")) {
                    RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseProject.jspa");
                    rd.forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (JiraKeyUtils.validIssueKey(pathInfo.substring(1).toUpperCase())) {
                    if (this.linkToIssue(request, response, pathInfo, true)) {
                        return;
                    }
                    break block21;
                }
                BrowseProjectUrlHelper helper = new BrowseProjectUrlHelper(pathInfo);
                String projectKey = helper.getProjectKey();
                Project project = null;
                if (projectKey != null) {
                    projectKey = projectKey.toUpperCase();
                    project = this.getProjectManager().getProjectObjByKey(projectKey);
                    if (project == null && projectKey.endsWith("/")) {
                        projectKey = projectKey.substring(0, projectKey.length() - 1);
                        project = this.getProjectManager().getProjectObjByKey(projectKey);
                    }
                }
                if (project != null) {
                    if (helper.getVersionId() != null) {
                        RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseVersion.jspa?id=" + project.getId() + "&versionId=" + helper.getVersionId());
                        rd.forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    if (helper.getComponentId() != null) {
                        RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseComponent.jspa?id=" + project.getId() + "&componentId=" + helper.getComponentId());
                        rd.forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    if (helper.getProjectAvatarId() != null) {
                        String avatarUrl = "/secure/projectavatar?pid=" + project.getId();
                        if (helper.getProjectAvatarId() != -1L) {
                            avatarUrl = avatarUrl + "&avatarId=" + helper.getProjectAvatarId();
                        }
                        RequestDispatcher rd = request.getRequestDispatcher(avatarUrl);
                        rd.forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseProject.jspa?id=" + project.getId());
                    rd.forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (this.linkToIssue(request, response, pathInfo, false)) {
                    return;
                }
                JiraContactHelper jiraContactHelper = this.getJiraContactHelper();
                String contactAdministratorLinkHtml = jiraContactHelper.getAdministratorContactLinkHtml(request.getContextPath(), this.getI18Helper());
                request.setAttribute("administratorContactLink", (Object)contactAdministratorLinkHtml);
                RequestDispatcher rd = request.getRequestDispatcher("/secure/views/projectnotfound.jsp");
                response.setStatus(404);
                rd.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            finally {
                UtilTimerStack.pop((String)"QuickLinkServlet.service()");
            }
        }
    }

    @SuppressWarnings(value={"HRS_REQUEST_PARAMETER_TO_HTTP_HEADER"}, justification="JIRA has a HeaderSanitisingFilter that protects against this")
    private boolean linkToIssue(HttpServletRequest request, HttpServletResponse response, String pathInfo, boolean redirectAlways) throws IOException, ServletException {
        String key = pathInfo.substring(1, pathInfo.length()).toUpperCase();
        try {
            Issue issue = this.getIssueManager().getIssueObject(key);
            if (issue == null && (issue = this.getChangeHistoryManager().findMovedIssue(key)) != null) {
                String contextPath = request.getContextPath() != null ? request.getContextPath() : "";
                String queryString = request.getQueryString() != null ? '?' + request.getQueryString() : "";
                response.sendRedirect(contextPath + "/browse/" + issue.getKey() + queryString);
                return true;
            }
            if (issue != null || redirectAlways) {
                request.setAttribute(AbstractIssueSelectAction.PREPOPULATED_ISSUE_OBJECT, (Object)issue);
                String queryString = request.getQueryString() != null ? "&" + request.getQueryString() : "";
                RequestDispatcher rd = request.getRequestDispatcher("/secure/ViewIssue.jspa?key=" + key + queryString);
                rd.forward((ServletRequest)request, (ServletResponse)response);
                return true;
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    IssueManager getIssueManager() {
        return ComponentAccessor.getIssueManager();
    }

    ChangeHistoryManager getChangeHistoryManager() {
        return ComponentAccessor.getChangeHistoryManager();
    }

    JiraContactHelper getJiraContactHelper() {
        return ComponentAccessor.getComponent(JiraContactHelper.class);
    }

    User getLoggedInUser() {
        return ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLoggedInUser();
    }

    I18nHelper getI18Helper() {
        return ComponentAccessor.getI18nHelperFactory().getInstance(this.getLoggedInUser());
    }
}

