/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.octo.captcha.CaptchaException;
import com.octo.captcha.service.CaptchaServiceException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JiraCaptchaServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(JiraCaptchaServlet.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
            try {
                String captchaId = httpServletRequest.getSession().getId();
                BufferedImage challenge = null;
                while (challenge == null) {
                    try {
                        challenge = ComponentManager.getComponentInstanceOfType(JiraCaptchaService.class).getImageCaptchaService().getImageChallengeForID(captchaId, httpServletRequest.getLocale());
                    }
                    catch (CaptchaException e) {
                        log.debug((Object)"CaptchaException thrown when image was being generated. This was most likely caused by running on OS X which has font size issues. Ignoring the exception. See http://jcaptcha.octo.com/jira/browse/FWK-58.", (Throwable)e);
                    }
                }
                this.writeJpegImage(jpegOutputStream, challenge);
            }
            catch (IllegalArgumentException e) {
                httpServletResponse.sendError(404);
                return;
            }
            catch (CaptchaServiceException e) {
                httpServletResponse.sendError(500);
                return;
            }
            byte[] captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
            httpServletResponse.setHeader("Cache-Control", "no-store");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setContentType("image/jpeg");
            ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
            responseOutputStream.write(captchaChallengeAsJpeg);
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeJpegImage(ByteArrayOutputStream os, BufferedImage bufferedImage) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(os);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        writer.setOutput(imageOutputStream);
        writer.write(bufferedImage);
    }
}

