/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class JiraServiceContainerImpl
implements JiraServiceContainer {
    private static final Logger log = Logger.getLogger(JiraServiceContainerImpl.class);
    private final Long id;
    private final JiraService service;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private volatile long lastRun;
    private volatile long delay;

    public JiraServiceContainerImpl(JiraService service, Long id) {
        this.service = service;
        this.id = id;
    }

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        this.service.init(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            log.debug((Object)"Service was inexplicably in the possible list twice. No harm done.  Just returning without doing anything.");
            return;
        }
        JiraThreadLocalUtils.preCall();
        try {
            this.service.run();
            this.running.set(false);
        }
        catch (Throwable throwable) {
            this.running.set(false);
            JiraThreadLocalUtils.postCall(log, new JiraThreadLocalUtils.ProblemDeterminationCallback(){

                @Override
                public void onOpenTransaction() {
                    log.error((Object)"Connection not cleared from thread local while running service.");
                    if (JiraServiceContainerImpl.this.service != null) {
                        log.error((Object)("Service name: " + JiraServiceContainerImpl.this.service.getName()));
                    } else {
                        log.error((Object)"The service is null");
                    }
                }
            });
            throw throwable;
        }
        JiraThreadLocalUtils.postCall(log, new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    public void destroy() {
        this.service.destroy();
    }

    @Override
    public boolean isInternal() {
        return this.service.isInternal();
    }

    @Override
    public final long getLastRun() {
        return this.lastRun;
    }

    @Override
    public final void setLastRun() {
        this.lastRun = System.currentTimeMillis();
    }

    @Override
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public boolean isDueAt(long time) {
        return this.getLastRun() + this.getDelay() <= time;
    }

    @Override
    public boolean isUnique() {
        return this.service.isUnique();
    }

    @Override
    public String getDescription() {
        return this.service.getDescription();
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public void setName(String name) {
        this.service.setName(name);
    }

    @Override
    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.service.getObjectConfiguration();
    }

    @Override
    public boolean hasProperty(String propertyKey) throws ObjectConfigurationException {
        return this.service.hasProperty(propertyKey);
    }

    @Override
    public String getProperty(String propertyKey) throws ObjectConfigurationException {
        return this.service.getProperty(propertyKey);
    }

    @Override
    public String getTextProperty(String propertyKey) throws ObjectConfigurationException {
        return this.service.getTextProperty(propertyKey);
    }

    @Override
    public Long getLongProperty(String propertyKey) throws ObjectConfigurationException {
        String property = this.getProperty(propertyKey);
        try {
            return new Long(property);
        }
        catch (NumberFormatException e) {
            throw new ObjectConfigurationException("Could not get Long from " + property);
        }
    }

    @Override
    public String getDefaultProperty(String propertyKey) throws ObjectConfigurationException {
        return this.getObjectConfiguration().getFieldDefault(propertyKey);
    }

    @Override
    public PropertySet getProperties() throws ObjectConfigurationException {
        return this.service.getProperties();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public String getKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getServiceClass() {
        return this.service.getClass().getName();
    }

    @Override
    public boolean isUsable() {
        return true;
    }

    public String toString() {
        return "Container: " + this.service.getClass().getName() + " " + (this.getDescription() != null ? this.getDescription() : "") + " delay [" + this.getDelay() + "ms]";
    }
}

