/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.InBuiltServiceTypes;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceConfigStore;
import com.atlassian.jira.service.ServiceException;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.atlassian.util.concurrent.SettableFuture;
import com.google.common.collect.Iterables;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class DefaultServiceManager
implements ServiceManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultServiceManager.class);
    private final ServiceConfigStore serviceConfigStore;
    private final Map<Long, JiraServiceContainer> services = CopyOnWriteMap.newHashMap();
    private final ServiceScheduleSkipperImpl scheduleSkipper = new ServiceScheduleSkipperImpl();
    private final ComponentClassManager componentClassManager;
    private final EventPublisher eventPublisher;
    private final PermissionManager permissionManager;
    private final InBuiltServiceTypes inBuiltServiceTypes;

    public DefaultServiceManager(ServiceConfigStore serviceConfigStore, ComponentClassManager componentClassManager, EventPublisher eventPublisher, PermissionManager permissionManager, InBuiltServiceTypes inBuiltServiceTypes) {
        this.eventPublisher = eventPublisher;
        this.permissionManager = permissionManager;
        this.inBuiltServiceTypes = inBuiltServiceTypes;
        this.serviceConfigStore = Assertions.notNull("serviceConfigStore", serviceConfigStore);
        this.componentClassManager = componentClassManager;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refreshAll();
    }

    @Override
    public synchronized Collection<JiraServiceContainer> getServices() {
        this.ensureServicesLoaded();
        return Collections.unmodifiableCollection(this.services.values());
    }

    @Override
    public Iterable<JiraServiceContainer> getServicesManageableBy(final User user) {
        final class CanManageServicePredicate
        implements com.google.common.base.Predicate<JiraServiceContainer> {
            CanManageServicePredicate() {
            }

            public boolean apply(final @Nullable JiraServiceContainer service) {
                if (Users.isAnonymous(user)) {
                    return false;
                }
                if (DefaultServiceManager.this.permissionManager.hasPermission(44, user)) {
                    return true;
                }
                if (DefaultServiceManager.this.permissionManager.hasPermission(0, user)) {
                    return Iterables.any(DefaultServiceManager.this.inBuiltServiceTypes.manageableBy(user), (com.google.common.base.Predicate)new com.google.common.base.Predicate<InBuiltServiceTypes.InBuiltServiceType>(){

                        public boolean apply(@Nullable InBuiltServiceTypes.InBuiltServiceType anInBuiltServiceType) {
                            return anInBuiltServiceType.getType().getName().equals(service.getServiceClass());
                        }
                    });
                }
                return false;
            }
        }
        return Iterables.filter(this.getServices(), (com.google.common.base.Predicate)new CanManageServicePredicate());
    }

    @Override
    public Iterable<JiraServiceContainer> getServicesForExecution(final long time) {
        final class ServiceDuePredicate
        implements Predicate<JiraServiceContainer> {
            ServiceDuePredicate() {
            }

            @Override
            public boolean evaluate(JiraServiceContainer service) {
                return service.isUsable() && !service.isRunning() && (DefaultServiceManager.this.scheduleSkipper.runNow(service.getId()) || service.isDueAt(time));
            }
        }
        final class SingleShotServiceContainerTransformer
        implements Function<JiraServiceContainer, JiraServiceContainer> {
            SingleShotServiceContainerTransformer() {
            }

            @Override
            public JiraServiceContainer get(JiraServiceContainer input) {
                if (DefaultServiceManager.this.scheduleSkipper.runNow(input.getId())) {
                    return new SingleShotServiceContainer(input, input.isDueAt(time));
                }
                return input;
            }
        }
        return Transformed.iterable(CollectionUtil.filter(this.getServices(), new ServiceDuePredicate()), new SingleShotServiceContainerTransformer());
    }

    @Override
    public synchronized boolean containsServiceWithId(Long id) {
        this.ensureServicesLoaded();
        return this.services.containsKey(id);
    }

    @Override
    public void refreshAll() {
        this.loadServices();
    }

    @Override
    public synchronized JiraServiceContainer getServiceWithId(Long id) throws Exception {
        this.ensureServicesLoaded();
        return this.services.get(id);
    }

    @Override
    public synchronized JiraServiceContainer getServiceWithName(String name) throws Exception {
        this.ensureServicesLoaded();
        JiraServiceContainer jiraServiceContainer = this.serviceConfigStore.getServiceConfigForName(name);
        if (jiraServiceContainer != null && this.services.containsKey(jiraServiceContainer.getId())) {
            return jiraServiceContainer;
        }
        return null;
    }

    @Override
    public synchronized JiraServiceContainer addService(String name, String serviceClassName, long delay) throws GenericEntityException, ServiceException, ClassNotFoundException {
        return this.addService(name, serviceClassName, delay, null);
    }

    @Override
    public synchronized JiraServiceContainer addService(String name, String serviceClassName, long delay, Map<String, String[]> params) throws GenericEntityException, ServiceException, ClassNotFoundException {
        if (StringUtils.isBlank((String)serviceClassName)) {
            throw new ServiceException("The service class name must not be blank");
        }
        Class serviceClass = this.componentClassManager.loadClass(serviceClassName);
        return this.addService(name, serviceClass, delay, params);
    }

    @Override
    public synchronized JiraServiceContainer addService(String name, Class<? extends JiraService> serviceClass, long delay) throws GenericEntityException, ServiceException {
        return this.addService(name, serviceClass, delay, null);
    }

    @Override
    public synchronized JiraServiceContainer addService(String name, Class<? extends JiraService> serviceClass, long delay, Map<String, String[]> params) throws GenericEntityException, ServiceException {
        JiraServiceContainer serviceContainer = this.serviceConfigStore.addServiceConfig(name, serviceClass, delay);
        if (params != null) {
            this.serviceConfigStore.editServiceConfig(serviceContainer, delay, params);
        }
        this.updateCache(serviceContainer);
        return serviceContainer;
    }

    @Override
    public synchronized void editServiceByName(String name, long delay, Map<String, String[]> params) throws Exception {
        JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForName(name);
        if (serviceContainer == null) {
            throw new IllegalArgumentException("There is not ServiceConfig with name: " + name);
        }
        if (!serviceContainer.isUsable()) {
            throw new IllegalStateException("You can not edit an unloadable service");
        }
        this.serviceConfigStore.editServiceConfig(serviceContainer, delay, params);
        this.updateCache(serviceContainer);
    }

    @Override
    public synchronized void editService(Long id, long delay, Map<String, String[]> params) throws Exception {
        JiraServiceContainer serviceContainer = this.serviceConfigStore.getServiceConfigForId(id);
        this.serviceConfigStore.editServiceConfig(serviceContainer, delay, params);
        this.updateCache(serviceContainer);
    }

    @Override
    public synchronized void removeServiceByName(String name) throws Exception {
        JiraServiceContainer jiraServiceContainer = this.serviceConfigStore.getServiceConfigForName(name);
        if (jiraServiceContainer == null) {
            throw new IllegalArgumentException("No services with name '" + name + "' exist.");
        }
        this.serviceConfigStore.removeServiceConfig(jiraServiceContainer);
        this.services.remove(jiraServiceContainer.getId());
    }

    @Override
    public synchronized void removeService(Long id) throws Exception {
        JiraServiceContainer jiraServiceContainer = this.serviceConfigStore.getServiceConfigForId(id);
        this.serviceConfigStore.removeServiceConfig(jiraServiceContainer);
        this.services.remove(jiraServiceContainer.getId());
    }

    @Override
    public synchronized void refreshService(Long id) throws Exception {
        JiraServiceContainer newJiraServiceContainer = this.serviceConfigStore.getServiceConfigForId(id);
        this.updateCache(newJiraServiceContainer);
    }

    @Override
    public synchronized void refreshServiceByName(String name) throws Exception {
        JiraServiceContainer jiraServiceContainer = this.serviceConfigStore.getServiceConfigForName(name);
        if (jiraServiceContainer == null) {
            throw new IllegalArgumentException("There is no ServiceConfig with name: " + name);
        }
        this.updateCache(jiraServiceContainer);
    }

    @Override
    public ServiceManager.ServiceScheduleSkipper getScheduleSkipper() {
        return this.scheduleSkipper;
    }

    private synchronized void ensureServicesLoaded() {
        if (!ComponentManager.getInstance().getState().isComponentsRegistered()) {
            throw new IllegalStateException("It is illegal to call the ServiceManager before all components are loaded. Please use " + Startable.class + " to get notified when JIRA has started.");
        }
        if (this.services.isEmpty()) {
            this.loadServices();
        }
    }

    private synchronized void loadServices() {
        this.services.clear();
        try {
            Collection<JiraServiceContainer> serviceConfigs = this.serviceConfigStore.getAllServiceConfigs();
            if (serviceConfigs == null || serviceConfigs.isEmpty()) {
                log.info((Object)"No Services to Load");
                return;
            }
            for (JiraServiceContainer jiraServiceContainer : serviceConfigs) {
                this.services.put(jiraServiceContainer.getId(), jiraServiceContainer);
            }
        }
        catch (Exception t) {
            log.error((Object)"Could not configure services: ", (Throwable)t);
        }
    }

    @GuardedBy(value="this")
    private void updateCache(JiraServiceContainer jiraServiceContainer) {
        this.ensureServicesLoaded();
        this.services.put(jiraServiceContainer.getId(), jiraServiceContainer);
    }

    private class SingleShotServiceContainer
    implements JiraServiceContainer {
        private final JiraServiceContainer delegate;
        private final boolean wasDueAnyway;

        private SingleShotServiceContainer(JiraServiceContainer delegate, boolean wasDueAnyway) {
            this.delegate = delegate;
            this.wasDueAnyway = wasDueAnyway;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            finally {
                DefaultServiceManager.this.scheduleSkipper.complete(this.getId());
            }
        }

        @Override
        public void setLastRun() {
            if (this.wasDueAnyway) {
                this.delegate.setLastRun();
            }
        }

        @Override
        public boolean isDueAt(long time) {
            return this.delegate.isDueAt(time);
        }

        @Override
        public long getLastRun() {
            return this.delegate.getLastRun();
        }

        @Override
        public long getDelay() {
            return this.delegate.getDelay();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public String getDefaultProperty(String propertyKey) throws ObjectConfigurationException {
            return this.delegate.getDefaultProperty(propertyKey);
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Long getId() {
            return this.delegate.getId();
        }

        @Override
        public String getKey() {
            return this.delegate.getKey();
        }

        @Override
        public Long getLongProperty(String propertyKey) throws ObjectConfigurationException {
            return this.delegate.getLongProperty(propertyKey);
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
            return this.delegate.getObjectConfiguration();
        }

        @Override
        public PropertySet getProperties() throws ObjectConfigurationException {
            return this.delegate.getProperties();
        }

        @Override
        public String getProperty(String propertyKey) throws ObjectConfigurationException {
            return this.delegate.getProperty(propertyKey);
        }

        @Override
        public String getServiceClass() {
            return this.delegate.getServiceClass();
        }

        @Override
        public String getTextProperty(String propertyKey) throws ObjectConfigurationException {
            return this.delegate.getTextProperty(propertyKey);
        }

        @Override
        public boolean hasProperty(String propertyKey) throws ObjectConfigurationException {
            return this.delegate.hasProperty(propertyKey);
        }

        @Override
        public boolean isInternal() {
            return this.delegate.isInternal();
        }

        @Override
        public boolean isRunning() {
            return this.delegate.isRunning();
        }

        @Override
        public boolean isUnique() {
            return this.delegate.isUnique();
        }

        @Override
        public boolean isUsable() {
            return this.delegate.isUsable();
        }

        @Override
        public void setDelay(long delay) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void init(PropertySet props) throws ObjectConfigurationException {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ServiceScheduleSkipperImpl
    implements ServiceManager.ServiceScheduleSkipper {
        private final ConcurrentMap<Long, SettableFuture<Void>> ids = new ConcurrentHashMap<Long, SettableFuture<Void>>();

        protected ServiceScheduleSkipperImpl() {
        }

        @Override
        public boolean addService(Long serviceId) {
            return this.ids.putIfAbsent(serviceId, (SettableFuture<Void>)new SettableFuture()) == null;
        }

        @Override
        public void awaitServiceRun(Long serviceId) throws InterruptedException {
            Future future = (Future)this.ids.get(serviceId);
            if (future != null) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        boolean runNow(Long serviceId) {
            return this.ids.containsKey(serviceId);
        }

        boolean complete(Long serviceId) {
            SettableFuture oldValue = (SettableFuture)this.ids.remove(serviceId);
            if (oldValue == null) {
                return false;
            }
            oldValue.set(null);
            return true;
        }
    }
}

