/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.security.util.AbstractGroupToSchemeMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class GroupToPermissionSchemeMapper
extends AbstractGroupToSchemeMapper {
    private final SchemePermissions schemePermissions;

    public GroupToPermissionSchemeMapper(PermissionSchemeManager permissionSchemeManager, SchemePermissions schemePermissions) throws GenericEntityException {
        super(permissionSchemeManager);
        this.schemePermissions = schemePermissions;
        this.setGroupMapping(this.realInit());
    }

    @Override
    protected Map init() throws GenericEntityException {
        return null;
    }

    protected Map realInit() throws GenericEntityException {
        HashMap mapping = new HashMap();
        List<GenericValue> schemes = this.getSchemeManager().getSchemes();
        for (int i = 0; i < schemes.size(); ++i) {
            GenericValue permissionScheme = schemes.get(i);
            Map<Integer, Permission> allSchemePermissions = this.schemePermissions.getSchemePermissions();
            for (Integer permissionId : allSchemePermissions.keySet()) {
                List<GenericValue> entities = this.getSchemeManager().getEntities(permissionScheme, new Long(permissionId.longValue()));
                for (int j = 0; j < entities.size(); ++j) {
                    GenericValue permissionRecord = entities.get(j);
                    if (!"group".equals(permissionRecord.getString("type"))) continue;
                    this.addEntry(mapping, permissionRecord.getString("parameter"), permissionScheme);
                }
            }
        }
        return mapping;
    }
}

