/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.security.util.AbstractGroupToSchemeMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class GroupToIssueSecuritySchemeMapper
extends AbstractGroupToSchemeMapper {
    private IssueSecurityLevelManager issueSecurityLevelManager;

    public GroupToIssueSecuritySchemeMapper(IssueSecuritySchemeManager issueSecuritySchemeManager, IssueSecurityLevelManager issueSecurityLevelManager) throws GenericEntityException {
        super(issueSecuritySchemeManager);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.setGroupMapping(this.init());
    }

    @Override
    protected Map init() throws GenericEntityException {
        HashMap mapping = new HashMap();
        if (this.getSchemeManager() != null && this.issueSecurityLevelManager != null) {
            List<GenericValue> schemes = this.getSchemeManager().getSchemes();
            for (int i = 0; i < schemes.size(); ++i) {
                GenericValue issueSecurityScheme = schemes.get(i);
                List<GenericValue> schemeIssueSecurityLevels = this.issueSecurityLevelManager.getSchemeIssueSecurityLevels(issueSecurityScheme.getLong("id"));
                for (int j = 0; j < schemeIssueSecurityLevels.size(); ++j) {
                    GenericValue issueSecurityLevel = schemeIssueSecurityLevels.get(j);
                    List<GenericValue> levelPermissions = this.getSchemeManager().getEntities(issueSecurityScheme, "group", issueSecurityLevel.getLong("id"));
                    for (int k = 0; k < levelPermissions.size(); ++k) {
                        GenericValue levelPermission = levelPermissions.get(k);
                        this.addEntry(mapping, levelPermission.getString("parameter"), issueSecurityScheme);
                    }
                }
            }
        }
        return mapping;
    }
}

