/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class SingleUser
extends AbstractProjectsSecurityType {
    public static final String DESC = "user";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserManager userManager;

    public SingleUser(JiraAuthenticationContext jiraAuthenticationContext, UserManager userManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userManager = userManager;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.single.user");
    }

    @Override
    public String getType() {
        return DESC;
    }

    @Override
    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
        if (!this.doValidation(key, parameters)) {
            String localisedMessage = this.jiraAuthenticationContext.getI18nHelper().getText("admin.permissions.errors.please.select.user");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        }
    }

    public boolean doValidation(String key, Map<String, String> parameters) {
        String value = parameters.get(key);
        return value != null && !StringUtils.isBlank((String)value) && this.userManager.getUser(value) != null;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument, User user, boolean issueCreation) {
        Assertions.notNull(DESC, user);
        Assertions.notNull("argument", argument);
        User singleUser = this.userManager.getUser(argument);
        return singleUser == null ? false : singleUser.equals(user);
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String username) {
        User user = this.userManager.getUser(username);
        if (user != null) {
            return Collections.singleton(user);
        }
        return Collections.emptySet();
    }
}

