/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.DefaultRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleComparator;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizProjectRoleAndActorStore
implements ProjectRoleAndActorStore {
    private static final Logger log = Logger.getLogger(OfBizProjectRoleAndActorStore.class);
    private static final String ENTITY_NAME = "ProjectRole";
    private final OfBizDelegator ofBizDelegator;
    private final RoleActorFactory roleActorFactory;
    private final GroupManager groupManager;
    private static final String PROJECT_ROLE_FIELD_NAME = "name";
    private static final String PROJECT_ROLE_FIELD_DESCRIPTION = "description";
    private static final String ROLE_ACTOR_PID = "pid";
    private static final String FIELD_ID = "id";
    private static final String ROLE_ACTOR_ROLETYPE = "roletype";
    private static final String ROLE_ACTOR_TYPE = "roletype";
    private static final String ROLE_ACTOR_PARAMETER = "roletypeparameter";
    private static final String ROLE_ACTOR_PROJECTROLEID = "projectroleid";
    private static final String ROLE_ACTOR_ENTITY_NAME = "ProjectRoleActor";

    public OfBizProjectRoleAndActorStore(OfBizDelegator genericDelegator, RoleActorFactory roleActorFactory, GroupManager groupManager) {
        this.ofBizDelegator = genericDelegator;
        this.roleActorFactory = roleActorFactory;
        this.groupManager = groupManager;
    }

    @Override
    public ProjectRole addProjectRole(ProjectRole projectRole) throws DataAccessException {
        try {
            GenericValue projectRoleGV = EntityUtils.createValue(ENTITY_NAME, EasyMap.build((Object)PROJECT_ROLE_FIELD_NAME, (Object)projectRole.getName(), (Object)PROJECT_ROLE_FIELD_DESCRIPTION, (Object)projectRole.getDescription()));
            return new ProjectRoleImpl(projectRoleGV.getLong(FIELD_ID), projectRoleGV.getString(PROJECT_ROLE_FIELD_NAME), projectRoleGV.getString(PROJECT_ROLE_FIELD_DESCRIPTION));
        }
        catch (Exception e) {
            log.error((Object)("Unable to store project role, removing any partially stored entity: " + projectRole.getName()), (Throwable)e);
            throw new DataAccessException(e);
        }
    }

    @Override
    public void updateProjectRole(ProjectRole projectRole) throws DataAccessException {
        try {
            GenericValue projectRoleGv = this.ofBizDelegator.findByPrimaryKey(ENTITY_NAME, EasyMap.build((Object)FIELD_ID, (Object)projectRole.getId()));
            projectRoleGv.set(PROJECT_ROLE_FIELD_NAME, (Object)projectRole.getName());
            projectRoleGv.set(PROJECT_ROLE_FIELD_DESCRIPTION, (Object)projectRole.getDescription());
            projectRoleGv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public Collection<ProjectRole> getAllProjectRoles() throws DataAccessException {
        try {
            List<GenericValue> projectRoleGVs = this.ofBizDelegator.findAll(ENTITY_NAME, EasyList.build((Object)"name ASC"));
            TreeSet<ProjectRole> projectRoles = new TreeSet<ProjectRole>(ProjectRoleComparator.COMPARATOR);
            for (GenericValue projectRoleGV : projectRoleGVs) {
                projectRoles.add(this.convertProjectRoleGVToProjectRoleObject(projectRoleGV));
            }
            return projectRoles;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public ProjectRole getProjectRole(Long id) throws DataAccessException {
        try {
            UtilTimerStack.push((String)"OfBizProjectRoleAndActorStore.getProjectRole");
            GenericValue projectRoleGV = this.ofBizDelegator.findByPrimaryKey(ENTITY_NAME, EasyMap.build((Object)FIELD_ID, (Object)id));
            ProjectRole projectRole = this.convertProjectRoleGVToProjectRoleObject(projectRoleGV);
            return projectRole;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        finally {
            UtilTimerStack.pop((String)"OfBizProjectRoleAndActorStore.getProjectRole");
        }
    }

    @Override
    public ProjectRole getProjectRoleByName(String name) throws DataAccessException {
        try {
            UtilTimerStack.push((String)"OfBizProjectRoleAndActorStore.getProjectRoleByName");
            List<GenericValue> projectRolesGV = this.ofBizDelegator.findByAnd(ENTITY_NAME, EasyMap.build((Object)PROJECT_ROLE_FIELD_NAME, (Object)name));
            if (projectRolesGV.size() == 1) {
                GenericValue projectRoleGV = projectRolesGV.get(0);
                ProjectRole projectRole = this.convertProjectRoleGVToProjectRoleObject(projectRoleGV);
                return projectRole;
            }
            if (projectRolesGV.size() > 1) {
                log.error((Object)("You have more than one ProjectRole with name " + name));
                throw new DataAccessException("You have more than one ProjectRole with name " + name);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        finally {
            UtilTimerStack.pop((String)"OfBizProjectRoleAndActorStore.getProjectRoleByName");
        }
        return null;
    }

    @Override
    public void deleteProjectRole(ProjectRole projectRole) throws DataAccessException {
        try {
            GenericValue projectRoleGV = this.ofBizDelegator.findByPrimaryKey(ENTITY_NAME, EasyMap.build((Object)FIELD_ID, (Object)projectRole.getId()));
            projectRoleGV.removeRelated("ChildProjectRoleActor");
            projectRoleGV.remove();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public ProjectRoleActors getProjectRoleActors(Long projectRoleId, Long projectId) throws DataAccessException {
        Set<ProjectRoleActor> actors = this.getRoleActors(projectId, projectRoleId);
        return new ProjectRoleActorsImpl(projectId, projectRoleId, actors);
    }

    @Override
    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) throws DataAccessException {
        this.updateRoleActors(projectRoleActors, projectRoleActors.getProjectId());
    }

    @Override
    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) throws DataAccessException {
        this.updateRoleActors(defaultRoleActors, null);
    }

    @Override
    public DefaultRoleActors getDefaultRoleActors(Long projectRoleId) throws DataAccessException {
        Set<ProjectRoleActor> actors = this.getRoleActors(null, projectRoleId);
        return new DefaultRoleActorsImpl(projectRoleId, actors);
    }

    @Override
    public void applyDefaultsRolesToProject(Project project) throws DataAccessException {
        try {
            Collection<ProjectRole> projectRoles = this.getAllProjectRoles();
            for (ProjectRole projectRole : projectRoles) {
                Set<ProjectRoleActor> roleActors = this.getRoleActors(null, projectRole.getId());
                for (ProjectRoleActor roleActor : roleActors) {
                    EntityUtils.createValue(ROLE_ACTOR_ENTITY_NAME, EasyMap.build((Object)ROLE_ACTOR_PID, (Object)project.getId(), (Object)ROLE_ACTOR_PROJECTROLEID, (Object)projectRole.getId(), (Object)"roletype", (Object)roleActor.getType(), (Object)ROLE_ACTOR_PARAMETER, (Object)roleActor.getParameter()));
                }
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void removeAllRoleActorsByNameAndType(String name, String type) throws DataAccessException {
        this.ofBizDelegator.removeByAnd(ROLE_ACTOR_ENTITY_NAME, EasyMap.build((Object)ROLE_ACTOR_PARAMETER, (Object)name, (Object)"roletype", (Object)type));
    }

    @Override
    public void removeAllRoleActorsByProject(Project project) throws DataAccessException {
        this.ofBizDelegator.removeByAnd(ROLE_ACTOR_ENTITY_NAME, EasyMap.build((Object)ROLE_ACTOR_PID, (Object)project.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getProjectIdsContainingRoleActorByNameAndType(String name, String type) throws DataAccessException {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        OfBizListIterator listIterator = null;
        try {
            EntityFieldMap condition = new EntityFieldMap(EasyMap.build((Object)ROLE_ACTOR_PARAMETER, (Object)name, (Object)"roletype", (Object)type), EntityOperator.AND);
            EntityFindOptions findOptions = new EntityFindOptions();
            findOptions.setDistinct(true);
            listIterator = this.ofBizDelegator.findListIteratorByCondition(ROLE_ACTOR_ENTITY_NAME, (EntityCondition)condition, null, EasyList.build((Object)ROLE_ACTOR_PID), null, findOptions);
            GenericValue projectIdGV = listIterator.next();
            while (projectIdGV != null) {
                projectIds.add(projectIdGV.getLong(ROLE_ACTOR_PID));
                projectIdGV = listIterator.next();
            }
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
        return projectIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) throws DataAccessException {
        OfBizListIterator listIterator = null;
        try {
            EntityExpr projectIdsClause = new EntityExpr(ROLE_ACTOR_PID, EntityOperator.IN, projectsToLimitBy);
            EntityFieldMap otherClause = new EntityFieldMap(EasyMap.build((Object)ROLE_ACTOR_PARAMETER, (Object)projectRoleParameter, (Object)"roletype", (Object)projectRoleType, (Object)ROLE_ACTOR_PROJECTROLEID, (Object)projectRole.getId()), EntityOperator.AND);
            EntityExpr condition = new EntityExpr((EntityCondition)otherClause, EntityOperator.AND, (EntityCondition)projectIdsClause);
            EntityFindOptions findOptions = new EntityFindOptions();
            findOptions.setDistinct(true);
            listIterator = this.ofBizDelegator.findListIteratorByCondition(ROLE_ACTOR_ENTITY_NAME, (EntityCondition)condition, null, EasyList.build((Object)ROLE_ACTOR_PID), null, findOptions);
            GenericValue projectIdGV = listIterator.next();
            ArrayList<Long> projectsIn = new ArrayList<Long>();
            while (projectIdGV != null) {
                projectsIn.add(projectIdGV.getLong(ROLE_ACTOR_PID));
                projectIdGV = listIterator.next();
            }
            ArrayList<Long> arrayList = projectsIn;
            return arrayList;
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userName) throws DataAccessException {
        MultiMap<Long, String, List<String>> groupNamesUserInForProjects = MultiMaps.create(new Supplier<List<String>>(){

            @Override
            public List<String> get() {
                return new ArrayList<String>();
            }
        });
        EntityExpr projectIdsClause = new EntityExpr(ROLE_ACTOR_PID, EntityOperator.IN, projectsToLimitBy);
        User user = this.getUser(userName);
        if (user != null) {
            List<String> groups;
            ArrayList<String> allGroups = new ArrayList<String>(this.groupManager.getGroupNamesForUser(user));
            int queryBatchSize = DefaultOfBizDelegator.getQueryBatchSize();
            for (int index = 0; index < allGroups.size(); index += groups.size()) {
                groups = this.getSafeSublist(allGroups, index, queryBatchSize + index);
                EntityExpr groupNamesClause = new EntityExpr(ROLE_ACTOR_PARAMETER, EntityOperator.IN, groups);
                EntityFieldMap otherClause = new EntityFieldMap(MapBuilder.build("roletype", projectRoleType, ROLE_ACTOR_PROJECTROLEID, projectRole.getId()), EntityOperator.AND);
                EntityExpr mainClaus = new EntityExpr((EntityCondition)otherClause, EntityOperator.AND, (EntityCondition)groupNamesClause);
                EntityExpr condition = projectsToLimitBy.isEmpty() ? mainClaus : new EntityExpr((EntityCondition)mainClaus, EntityOperator.AND, (EntityCondition)projectIdsClause);
                EntityFindOptions findOptions = new EntityFindOptions();
                findOptions.setDistinct(true);
                OfBizListIterator listIterator = this.ofBizDelegator.findListIteratorByCondition(ROLE_ACTOR_ENTITY_NAME, (EntityCondition)condition, null, Arrays.asList(ROLE_ACTOR_PID, ROLE_ACTOR_PARAMETER), null, findOptions);
                try {
                    GenericValue projectIdGV = listIterator.next();
                    while (projectIdGV != null) {
                        groupNamesUserInForProjects.put(projectIdGV.getLong(ROLE_ACTOR_PID), projectIdGV.getString(ROLE_ACTOR_PARAMETER));
                        projectIdGV = listIterator.next();
                    }
                    continue;
                }
                finally {
                    if (listIterator != null) {
                        listIterator.close();
                    }
                }
            }
            return groupNamesUserInForProjects;
        }
        log.error((Object)("Unable to find user with name: " + userName));
        throw new IllegalArgumentException("Unable to find user with name: " + userName);
    }

    private <T> List<T> getSafeSublist(List<T> originalList, int start, int end) {
        if (start > originalList.size()) {
            return Collections.emptyList();
        }
        if (end > originalList.size()) {
            end = originalList.size();
        }
        return originalList.subList(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ProjectRoleActor> getRoleActors(Long projectId, Long projectRoleId) throws DataAccessException {
        try {
            UtilTimerStack.push((String)"OfBizProjectRoleAndActorStore.getRoleActors");
            HashSet<ProjectRoleActor> actors = new HashSet<ProjectRoleActor>();
            List<GenericValue> actorGVs = this.ofBizDelegator.findByAnd(ROLE_ACTOR_ENTITY_NAME, MapBuilder.build(ROLE_ACTOR_PROJECTROLEID, projectRoleId, ROLE_ACTOR_PID, projectId));
            for (GenericValue actorGV : actorGVs) {
                try {
                    ProjectRoleActor actor = this.roleActorFactory.createRoleActor(actorGV.getLong(FIELD_ID), projectRoleId, projectId, actorGV.getString("roletype"), actorGV.getString(ROLE_ACTOR_PARAMETER));
                    actors.add(actor);
                }
                catch (IllegalArgumentException iae) {
                    log.warn((Object)("Unable to create a project role actor for type '" + actorGV.getString("roletype") + "'. " + iae.getMessage()));
                }
                catch (RoleActorDoesNotExistException ex) {
                    log.warn((Object)("Unable to create a project role actor. " + ex.getMessage()));
                }
            }
            HashSet<ProjectRoleActor> hashSet = actors;
            return hashSet;
        }
        finally {
            UtilTimerStack.pop((String)"OfBizProjectRoleAndActorStore.getRoleActors");
        }
    }

    private void updateRoleActors(DefaultRoleActors projectRoleActors, Long projectId) {
        try {
            Set<ProjectRoleActor> existingActors = this.getRoleActors(projectId, projectRoleActors.getProjectRoleId());
            HashSet<RoleActor> actorsToAdd = new HashSet<RoleActor>(projectRoleActors.getRoleActors());
            HashSet<ProjectRoleActor> actorsToRemove = new HashSet<ProjectRoleActor>(existingActors);
            actorsToRemove.removeAll(actorsToAdd);
            actorsToAdd.removeAll(existingActors);
            if (!actorsToRemove.isEmpty()) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (ProjectRoleActor roleActor : actorsToRemove) {
                    ids.add(roleActor.getId());
                }
                this.ofBizDelegator.removeByOr(ROLE_ACTOR_ENTITY_NAME, FIELD_ID, ids);
            }
            for (RoleActor roleActor : actorsToAdd) {
                EntityUtils.createValue(ROLE_ACTOR_ENTITY_NAME, EasyMap.build((Object)ROLE_ACTOR_PID, (Object)projectId, (Object)ROLE_ACTOR_PROJECTROLEID, (Object)projectRoleActors.getProjectRoleId(), (Object)"roletype", (Object)roleActor.getType(), (Object)ROLE_ACTOR_PARAMETER, (Object)roleActor.getParameter()));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    private ProjectRole convertProjectRoleGVToProjectRoleObject(GenericValue projectRoleGV) throws GenericEntityException {
        ProjectRoleImpl role = null;
        if (projectRoleGV != null) {
            role = new ProjectRoleImpl(projectRoleGV.getLong(FIELD_ID), projectRoleGV.getString(PROJECT_ROLE_FIELD_NAME), projectRoleGV.getString(PROJECT_ROLE_FIELD_DESCRIPTION));
        }
        return role;
    }

    User getUser(String userName) {
        return UserUtils.getUser(userName);
    }
}

